/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.dbscan.predicates.CorePredicate;
import elki.clustering.dbscan.predicates.PreDeConNeighborPredicate;
import elki.clustering.subspace.PreDeCon;
import elki.data.type.SimpleTypeInformation;
import elki.database.Database;
import elki.database.ids.DBIDRef;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04)", url="https://doi.org/10.1109/ICDM.2004.10087", bibkey="DBLP:conf/icdm/BohmKKK04")
public class PreDeConCorePredicate
implements CorePredicate<PreDeConNeighborPredicate.PreDeConModel> {
    protected PreDeCon.Settings settings;

    public PreDeConCorePredicate(PreDeCon.Settings settings) {
        this.settings = settings;
    }

    public Instance instantiate(Database database) {
        return new Instance(this.settings);
    }

    @Override
    public boolean acceptsType(SimpleTypeInformation<? extends PreDeConNeighborPredicate.PreDeConModel> type) {
        return type.getRestrictionClass().isAssignableFrom(PreDeConNeighborPredicate.PreDeConModel.class);
    }

    public static class Par
    implements Parameterizer {
        protected PreDeCon.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (PreDeCon.Settings)config.tryInstantiate(PreDeCon.Settings.class);
        }

        public PreDeConCorePredicate make() {
            return new PreDeConCorePredicate(this.settings);
        }
    }

    public static class Instance
    implements CorePredicate.Instance<PreDeConNeighborPredicate.PreDeConModel> {
        protected PreDeCon.Settings settings;

        public Instance(PreDeCon.Settings settings) {
            this.settings = settings;
        }

        @Override
        public boolean isCorePoint(DBIDRef point, PreDeConNeighborPredicate.PreDeConModel model) {
            return model.pdim <= this.settings.lambda && model.ids.size() >= this.settings.minpts;
        }
    }
}

