/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.dbscan.predicates;

import elki.clustering.dbscan.predicates.AbstractRangeQueryNeighborPredicate;
import elki.clustering.subspace.PreDeCon;
import elki.data.NumberVector;
import elki.data.type.SimpleTypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.DoubleDBIDList;
import elki.database.ids.DoubleDBIDListIter;
import elki.database.ids.HashSetModifiableDBIDs;
import elki.database.ids.SetDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.range.RangeSearcher;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.math.MeanVariance;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="Christian B\u00f6hm, Karin Kailing, Hans-Peter Kriegel, Peer Kr\u00f6ger", title="Density Connected Clustering with Local Subspace Preferences", booktitle="Proc. 4th IEEE Int. Conf. on Data Mining (ICDM'04)", url="https://doi.org/10.1109/ICDM.2004.10087", bibkey="DBLP:conf/icdm/BohmKKK04")
public class PreDeConNeighborPredicate
extends AbstractRangeQueryNeighborPredicate<NumberVector, PreDeConModel, PreDeConModel> {
    private static final Logging LOG = Logging.getLogger(PreDeConNeighborPredicate.class);
    private MeanVariance mvSize = new MeanVariance();
    private MeanVariance mvVar = new MeanVariance();
    private PreDeCon.Settings settings;

    public PreDeConNeighborPredicate(PreDeCon.Settings settings) {
        super(settings.epsilon * settings.epsilon, SquaredEuclideanDistance.STATIC);
        this.settings = settings;
    }

    public Instance instantiate(Database database) {
        Relation relation = database.getRelation(this.distance.getInputTypeRestriction(), new Object[0]);
        RangeSearcher rq = new QueryBuilder(relation, this.distance).rangeByDBID(this.epsilon);
        this.mvSize.reset();
        this.mvVar.reset();
        DataStore<PreDeConModel> storage = this.preprocess(PreDeConModel.class, relation, (RangeSearcher<DBIDRef>)rq);
        if (LOG.isVerbose()) {
            LOG.verbose((CharSequence)("Average neighborhood size: " + this.mvSize.toString()));
            LOG.verbose((CharSequence)("Average variance size: " + this.mvVar.toString()));
            int dim = RelationUtil.dimensionality((Relation)relation);
            if (this.mvSize.getMean() < (double)(5 * dim)) {
                LOG.verbose((CharSequence)"The epsilon parameter may be chosen too small.");
            } else if (this.mvSize.getMean() > 0.5 * (double)relation.size()) {
                LOG.verbose((CharSequence)"The epsilon parameter may be chosen too large.");
            } else {
                LOG.verbose((CharSequence)("As a first guess, you can try minPts < " + (int)this.mvSize.getMean() / dim + " and delta > " + this.mvVar.getMean() + ", but you will need to experiment with these parameters and epsilon."));
            }
        }
        return new Instance(relation.getDBIDs(), storage);
    }

    @Override
    protected PreDeConModel computeLocalModel(DBIDRef id, DoubleDBIDList neighbors, Relation<? extends NumberVector> relation) {
        int d;
        int referenceSetSize = neighbors.size();
        this.mvSize.put((double)referenceSetSize);
        if (referenceSetSize < 0) {
            LOG.warning((CharSequence)"Empty reference set - should at least include the query point!");
            return new PreDeConModel(Integer.MAX_VALUE, (SetDBIDs)DBIDUtil.EMPTYDBIDS);
        }
        NumberVector obj = (NumberVector)relation.get(id);
        int dim = obj.getDimensionality();
        double[] s = new double[dim];
        DoubleDBIDListIter neighbor = neighbors.iter();
        while (neighbor.valid()) {
            NumberVector o = (NumberVector)relation.get((DBIDRef)neighbor);
            d = 0;
            while (d < dim) {
                double diff = obj.doubleValue(d) - o.doubleValue(d);
                int n = d++;
                s[n] = s[n] + diff * diff;
            }
            neighbor.advance();
        }
        for (int d2 = 0; d2 < dim; ++d2) {
            int n = d2;
            s[n] = s[n] / (double)referenceSetSize;
            this.mvVar.put(s[d2]);
        }
        double[] weights = new double[dim];
        int pdim = 0;
        for (d = 0; d < dim; ++d) {
            if (s[d] <= this.settings.delta) {
                weights[d] = this.settings.kappa;
                ++pdim;
                continue;
            }
            weights[d] = 1.0;
        }
        HashSetModifiableDBIDs survivors = DBIDUtil.newHashSet((int)referenceSetSize);
        DoubleDBIDListIter neighbor2 = neighbors.iter();
        while (neighbor2.valid()) {
            NumberVector o = (NumberVector)relation.get((DBIDRef)neighbor2);
            double dev = 0.0;
            for (int d3 = 0; d3 < dim; ++d3) {
                double diff = obj.doubleValue(d3) - o.doubleValue(d3);
                dev += weights[d3] * diff * diff;
            }
            if (dev <= this.epsilon) {
                survivors.add((DBIDRef)neighbor2);
            }
            neighbor2.advance();
        }
        return new PreDeConModel(pdim, (SetDBIDs)survivors);
    }

    @Override
    Logging getLogger() {
        return LOG;
    }

    @Override
    public SimpleTypeInformation<PreDeConModel> getOutputType() {
        return new SimpleTypeInformation(PreDeConModel.class);
    }

    public static class Par
    implements Parameterizer {
        protected PreDeCon.Settings settings;

        public void configure(Parameterization config) {
            this.settings = (PreDeCon.Settings)config.tryInstantiate(PreDeCon.Settings.class);
        }

        public PreDeConNeighborPredicate make() {
            return new PreDeConNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<PreDeConModel, PreDeConModel> {
        public Instance(DBIDs ids, DataStore<PreDeConModel> storage) {
            super(ids, storage);
        }

        @Override
        public PreDeConModel getNeighbors(DBIDRef reference) {
            PreDeConModel asymmetric = (PreDeConModel)this.storage.get(reference);
            HashSetModifiableDBIDs ids = DBIDUtil.newHashSet((int)asymmetric.ids.size());
            DBIDIter neighbor = asymmetric.ids.iter();
            while (neighbor.valid()) {
                if (((PreDeConModel)this.storage.get((DBIDRef)neighbor)).ids.contains(reference)) {
                    ids.add((DBIDRef)neighbor);
                }
                neighbor.advance();
            }
            return new PreDeConModel(asymmetric.pdim, (SetDBIDs)ids);
        }

        @Override
        public DBIDIter iterDBIDs(PreDeConModel neighbors) {
            return neighbors.ids.iter();
        }
    }

    public static class PreDeConModel {
        int pdim;
        SetDBIDs ids;

        public PreDeConModel(int pdim, SetDBIDs ids) {
            this.pdim = pdim;
            this.ids = ids;
        }
    }
}

