/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em;

import elki.clustering.em.BetulaGMM;
import elki.clustering.em.EM;
import elki.clustering.em.models.BetulaClusterModel;
import elki.clustering.em.models.BetulaClusterModelFactory;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.ClusterFeature;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jafama.FastMath;

@Priority(value=-100)
@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class BetulaGMMWeighted
extends BetulaGMM {
    public BetulaGMMWeighted(CFTree.Factory<?> cffactory, double delta, int k, int maxiter, boolean soft, BetulaClusterModelFactory<?> initialization, double prior) {
        super(cffactory, delta, k, maxiter, soft, initialization, prior);
    }

    @Override
    public double assignProbabilitiesToInstances(ArrayList<? extends ClusterFeature> cfs, List<? extends BetulaClusterModel> models, Map<ClusterFeature, double[]> probClusterIGivenX) {
        int k = models.size();
        double emSum = 0.0;
        int n = 0;
        for (int i = 0; i < cfs.size(); ++i) {
            ClusterFeature cfsi = cfs.get(i);
            double[] probs = new double[k];
            for (int j = 0; j < k; ++j) {
                double v = models.get(j).estimateLogDensity(cfsi);
                probs[j] = v > -100000.0 ? v : -100000.0;
            }
            double logP = EM.logSumExp(probs);
            for (int j = 0; j < k; ++j) {
                probs[j] = FastMath.exp((double)(probs[j] - logP));
            }
            probClusterIGivenX.put(cfsi, probs);
            emSum += logP * (double)cfsi.getWeight();
            n += cfsi.getWeight();
        }
        return emSum / (double)n;
    }

    public static class Par
    extends BetulaGMM.Par {
        @Override
        public BetulaGMMWeighted make() {
            return new BetulaGMMWeighted(this.cffactory, this.delta, this.k, this.maxiter, this.soft, this.initialization, this.prior);
        }
    }
}

