/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.BetulaClusterModelFactory;
import elki.clustering.em.models.MultivariateGaussianModel;
import elki.clustering.kmeans.initialization.betula.AbstractCFKMeansInitialization;
import elki.clustering.kmeans.initialization.betula.CFKPlusPlusLeaves;
import elki.index.tree.betula.CFTree;
import elki.index.tree.betula.features.ClusterFeature;
import elki.math.linearalgebra.VMath;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

@Reference(authors="Andreas Lang and Erich Schubert", title="BETULA: Fast Clustering of Large Data with Improved BIRCH CF-Trees", booktitle="Information Systems", url="https://doi.org/10.1016/j.is.2021.101918", bibkey="DBLP:journals/is/LangS22")
public class BetulaMultivariateGaussianModelFactory
implements BetulaClusterModelFactory<MultivariateGaussianModel> {
    protected AbstractCFKMeansInitialization initializer;

    public BetulaMultivariateGaussianModelFactory(AbstractCFKMeansInitialization initializer) {
        this.initializer = initializer;
    }

    @Override
    public List<MultivariateGaussianModel> buildInitialModels(List<? extends ClusterFeature> cfs, int k, CFTree<?> tree) {
        double[][] initialMeans = this.initializer.chooseInitialMeans(tree, cfs, k);
        assert (initialMeans.length == k);
        double[][] covmat = (double[][])tree.getRoot().getCF().covariance().clone();
        VMath.timesEquals((double[][])covmat, (double)FastMath.pow((double)k, (double)(-2.0 / (double)covmat.length)));
        ArrayList<MultivariateGaussianModel> models = new ArrayList<MultivariateGaussianModel>(k);
        for (double[] nv : initialMeans) {
            models.add(new MultivariateGaussianModel(1.0 / (double)k, nv, covmat));
        }
        return models;
    }

    public static class Par
    implements Parameterizer {
        protected AbstractCFKMeansInitialization initializer;

        public void configure(Parameterization config) {
            new ObjectParameter(BetulaClusterModelFactory.INIT_ID, AbstractCFKMeansInitialization.class, CFKPlusPlusLeaves.class).grab(config, x -> {
                this.initializer = x;
            });
        }

        public BetulaMultivariateGaussianModelFactory make() {
            return new BetulaMultivariateGaussianModelFactory(this.initializer);
        }
    }
}

