/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.DiagonalGaussianModel;
import elki.clustering.em.models.EMClusterModelFactory;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.initialization.RandomlyChosen;
import elki.data.NumberVector;
import elki.data.model.EMModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.MeanVariance;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class DiagonalGaussianModelFactory
implements EMClusterModelFactory<NumberVector, EMModel> {
    protected KMeansInitialization initializer;

    public DiagonalGaussianModelFactory(KMeansInitialization initializer) {
        this.initializer = initializer;
    }

    @Override
    public List<DiagonalGaussianModel> buildInitialModels(Relation<? extends NumberVector> relation, int k) {
        double[][] initialMeans = this.initializer.chooseInitialMeans(relation, k, (NumberVectorDistance<?>)SquaredEuclideanDistance.STATIC);
        assert (initialMeans.length == k);
        MeanVariance[] mvs = MeanVariance.of(relation);
        double[] variances = new double[mvs.length];
        double f = FastMath.pow((double)k, (double)(-2.0 / (double)variances.length));
        for (int d = 0; d < mvs.length; ++d) {
            double v = mvs[d].getPopulationVariance();
            variances[d] = v > 0.0 ? v * f : 1.0E-10;
        }
        ArrayList<DiagonalGaussianModel> models = new ArrayList<DiagonalGaussianModel>(k);
        for (double[] nv : initialMeans) {
            models.add(new DiagonalGaussianModel(1.0 / (double)k, nv, variances));
        }
        return models;
    }

    public static class Par
    implements Parameterizer {
        protected KMeansInitialization initializer;

        public void configure(Parameterization config) {
            new ObjectParameter(EMClusterModelFactory.INIT_ID, KMeansInitialization.class, RandomlyChosen.class).grab(config, x -> {
                this.initializer = x;
            });
        }

        public DiagonalGaussianModelFactory make() {
            return new DiagonalGaussianModelFactory(this.initializer);
        }
    }
}

