/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.BetulaClusterModel;
import elki.data.NumberVector;
import elki.data.model.EMModel;
import elki.index.tree.betula.features.ClusterFeature;
import elki.math.MathUtil;
import elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class SphericalGaussianModel
implements BetulaClusterModel {
    private static final double SINGULARITY_CHEAT = 1.0E-10;
    double[] mean;
    double variance;
    double[] nmea;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double priorvar;

    public SphericalGaussianModel(double weight, double[] mean) {
        this(weight, mean, 1.0);
    }

    public SphericalGaussianModel(double weight, double[] mean, double var) {
        this.weight = weight;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.logNormDet = FastMath.log((double)weight) - 0.5 * this.logNorm;
        this.nmea = new double[mean.length];
        this.priorvar = this.variance = var > 0.0 ? var : 1.0E-10;
        this.wsum = 0.0;
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        this.variance = 0.0;
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        int i;
        assert (vec.getDimensionality() == this.mean.length);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        double nwsum = this.wsum + wei;
        double f = wei / nwsum;
        for (i = 0; i < this.mean.length; ++i) {
            this.nmea[i] = this.mean[i] + (vec.doubleValue(i) - this.mean[i]) * f;
        }
        for (i = 0; i < this.mean.length; ++i) {
            double vi = vec.doubleValue(i);
            this.variance += (vi - this.nmea[i]) * (vi - this.mean[i]) * wei;
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        int dim = this.mean.length;
        this.weight = weight;
        if (prior > 0.0 && this.priorvar > 0.0) {
            double nu = (double)dim + 2.0;
            this.variance = this.variance / (double)dim + prior * this.priorvar;
            this.variance /= this.wsum + prior * (nu + (double)dim + 2.0);
        } else if (this.wsum > 0.0) {
            this.variance /= (double)dim * this.wsum;
        }
        double logDet = (double)dim * FastMath.log((double)MathUtil.max((double)this.variance, (double)1.0E-10));
        this.logNormDet = FastMath.log((double)weight) - 0.5 * (this.logNorm + logDet);
        if (prior > 0.0 && this.priorvar == 0.0) {
            this.priorvar = this.variance;
        }
    }

    public double mahalanobisDistance(double[] vec) {
        double agg = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            double diff = vec[i] - this.mean[i];
            agg += diff / this.variance * diff;
        }
        return agg;
    }

    public double mahalanobisDistance(NumberVector vec) {
        double agg = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double diff = vec.doubleValue(i) - this.mean[i];
            agg += diff / this.variance * diff;
        }
        return agg;
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, VMath.timesEquals((double[][])VMath.identity((int)this.nmea.length, (int)this.nmea.length), (double)this.variance));
    }

    @Override
    public double estimateLogDensity(ClusterFeature cf) {
        int dim = this.mean.length;
        double v = cf.variance() / (double)dim + this.variance;
        double agg = 0.0;
        for (int i = 0; i < dim; ++i) {
            double diff = cf.centroid(i) - this.mean[i];
            agg += diff / v * diff;
        }
        return -0.5 * (agg + this.logNorm + FastMath.log((double)v) * (double)dim);
    }

    @Override
    public void updateE(ClusterFeature cf, double wei) {
        assert (cf.getDimensionality() == this.mean.length);
        double nwsum = this.wsum + wei;
        for (int i = 0; i < this.mean.length; ++i) {
            this.nmea[i] = this.mean[i] + (cf.centroid(i) - this.mean[i]) * wei / nwsum;
        }
        double ovar = this.variance / (double)this.mean.length;
        this.variance = 0.0;
        for (int i = 0; i < this.mean.length; ++i) {
            double vi = cf.centroid(i);
            this.variance += ovar + wei * cf.variance(i) + wei * (vi - this.nmea[i]) * (vi - this.mean[i]);
        }
        this.wsum = nwsum;
        System.arraycopy(this.nmea, 0, this.mean, 0, this.nmea.length);
    }
}

