/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.EMClusterModel;
import elki.clustering.em.models.MultivariateGaussianModel;
import elki.data.NumberVector;
import elki.data.model.EMModel;
import elki.math.MathUtil;
import elki.math.linearalgebra.CholeskyDecomposition;
import elki.math.linearalgebra.ConstrainedQuadraticProblemSolver;
import elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class TextbookMultivariateGaussianModel
implements EMClusterModel<NumberVector, EMModel> {
    double[] mean;
    double[][] covariance;
    CholeskyDecomposition chol;
    double[] tmp;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double[][] priormatrix;

    public TextbookMultivariateGaussianModel(double weight, double[] mean) {
        this(weight, mean, null);
    }

    public TextbookMultivariateGaussianModel(double weight, double[] mean, double[][] covariance) {
        this.weight = weight;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.tmp = new double[mean.length];
        this.covariance = covariance != null ? VMath.copy((double[][])covariance) : VMath.identity((int)mean.length, (int)mean.length);
        this.priormatrix = (double[][])(covariance != null ? covariance : null);
        this.wsum = 0.0;
        this.chol = MultivariateGaussianModel.updateCholesky(this.covariance, null);
        this.logNormDet = FastMath.log((double)weight) - 0.5 * this.logNorm - MultivariateGaussianModel.getHalfLogDeterminant(this.chol);
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        VMath.clear((double[])this.mean);
        VMath.clear((double[][])this.covariance);
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        assert (vec.getDimensionality() == this.mean.length);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        int dim = this.mean.length;
        int i = 0;
        while (i < dim) {
            double vi = this.tmp[i] = vec.doubleValue(i);
            double vi_wei = vi * wei;
            int n = i;
            this.mean[n] = this.mean[n] + vi_wei;
            double[] cov_i = this.covariance[i];
            for (int j = 0; j < i; ++j) {
                int n2 = j;
                cov_i[n2] = cov_i[n2] + vi_wei * this.tmp[j];
            }
            int n3 = i++;
            cov_i[n3] = cov_i[n3] + vi_wei * vi;
        }
        this.wsum += wei;
    }

    public void updateE(double[] vec, double[][] covm, double sca, double wei) {
        assert (vec.length == this.mean.length);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        VMath.plusTimesEquals((double[])this.mean, (double[])vec, (double)sca);
        VMath.plusTimesEquals((double[][])this.covariance, (double[][])covm, (double)sca);
        this.wsum += wei;
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        int dim = this.covariance.length;
        this.weight = weight;
        double f = this.wsum > Double.MIN_NORMAL && this.wsum < Double.POSITIVE_INFINITY ? 1.0 / this.wsum : 1.0;
        int i = 0;
        while (i < dim) {
            int n = i++;
            this.mean[n] = this.mean[n] * f;
        }
        if (prior > 0.0 && this.priormatrix != null) {
            double nu = (double)dim + 2.0;
            double f2 = 1.0 / (this.wsum + prior * (nu + (double)dim + 2.0));
            for (int i2 = 0; i2 < dim; ++i2) {
                double[] row_i = this.covariance[i2];
                double[] pri_i = this.priormatrix[i2];
                double fi = this.mean[i2] * this.wsum;
                for (int j = 0; j < i2; ++j) {
                    this.covariance[j][i2] = row_i[j] = (row_i[j] - fi * this.mean[j] + prior * pri_i[j]) * f2;
                }
                row_i[i2] = (row_i[i2] - fi * this.mean[i2] + prior * pri_i[i2]) * f2;
            }
        } else {
            for (i = 0; i < dim; ++i) {
                double[] covariance_i = this.covariance[i];
                double mean_i = this.mean[i];
                for (int j = 0; j < i; ++j) {
                    this.covariance[j][i] = covariance_i[j] = covariance_i[j] * f - mean_i * this.mean[j];
                }
                covariance_i[i] = covariance_i[i] * f - mean_i * mean_i;
            }
        }
        this.chol = MultivariateGaussianModel.updateCholesky(this.covariance, null);
        this.logNormDet = FastMath.log((double)weight) - 0.5 * this.logNorm - MultivariateGaussianModel.getHalfLogDeterminant(this.chol);
        if (prior > 0.0 && this.priormatrix == null) {
            this.priormatrix = VMath.copy((double[][])this.covariance);
        }
    }

    public double mahalanobisDistance(NumberVector vec) {
        return VMath.squareSum((double[])this.chol.solveLInplace(VMath.minusEquals((double[])vec.toArray(), (double[])this.mean)));
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, this.covariance);
    }

    public void clone(TextbookMultivariateGaussianModel other) {
        System.arraycopy(other.mean, 0, this.mean, 0, this.mean.length);
        for (int d = 0; d < this.covariance.length; ++d) {
            System.arraycopy(other.covariance[d], 0, this.covariance[d], 0, this.covariance[d].length);
        }
        this.logNorm = other.logNorm;
        this.logNormDet = other.logNormDet;
        this.chol = other.chol;
        this.weight = other.weight;
        this.wsum = other.wsum;
    }

    public void calculateModelLimits(double[] min, double[] max, ConstrainedQuadraticProblemSolver solver, double ipiPow, double[] minpnt, double[] maxpnt, double[] ret) {
        VMath.minusEquals((double[])min, (double[])this.mean);
        VMath.minusEquals((double[])max, (double[])this.mean);
        double[][] covInv = VMath.inverse((double[][])this.covariance);
        double icovdetsqrt = FastMath.exp((double)(-1.0 * MultivariateGaussianModel.getHalfLogDeterminant(this.chol)));
        double mahalanobisSQDmax = 2.0 * solver.solve(covInv, null, 0.0, min, max, maxpnt);
        double mahalanobisSQDmin = -2.0 * solver.solve(VMath.timesEquals((double[][])covInv, (double)-1.0), null, 0.0, min, max, minpnt);
        double f = ipiPow * icovdetsqrt;
        ret[0] = FastMath.exp((double)(mahalanobisSQDmax * -0.5)) * f;
        ret[1] = FastMath.exp((double)(mahalanobisSQDmin * -0.5)) * f;
    }
}

