/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.EMClusterModelFactory;
import elki.clustering.em.models.TextbookMultivariateGaussianModel;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.initialization.RandomlyChosen;
import elki.data.NumberVector;
import elki.data.model.EMModel;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.linearalgebra.CovarianceMatrix;
import elki.math.linearalgebra.VMath;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.List;
import net.jafama.FastMath;

public class TextbookMultivariateGaussianModelFactory
implements EMClusterModelFactory<NumberVector, EMModel> {
    protected KMeansInitialization initializer;

    public TextbookMultivariateGaussianModelFactory(KMeansInitialization initializer) {
        this.initializer = initializer;
    }

    @Override
    public List<TextbookMultivariateGaussianModel> buildInitialModels(Relation<? extends NumberVector> relation, int k) {
        double[][] initialMeans = this.initializer.chooseInitialMeans(relation, k, (NumberVectorDistance<?>)SquaredEuclideanDistance.STATIC);
        assert (initialMeans.length == k);
        double[][] covmat = CovarianceMatrix.make(relation).destroyToPopulationMatrix();
        VMath.timesEquals((double[][])covmat, (double)FastMath.pow((double)k, (double)(-2.0 / (double)covmat.length)));
        ArrayList<TextbookMultivariateGaussianModel> models = new ArrayList<TextbookMultivariateGaussianModel>(k);
        for (double[] nv : initialMeans) {
            models.add(new TextbookMultivariateGaussianModel(1.0 / (double)k, nv, covmat));
        }
        return models;
    }

    public static class Par
    implements Parameterizer {
        protected KMeansInitialization initializer;

        public void configure(Parameterization config) {
            new ObjectParameter(EMClusterModelFactory.INIT_ID, KMeansInitialization.class, RandomlyChosen.class).grab(config, x -> {
                this.initializer = x;
            });
        }

        public TextbookMultivariateGaussianModelFactory make() {
            return new TextbookMultivariateGaussianModelFactory(this.initializer);
        }
    }
}

