/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.em.models;

import elki.clustering.em.models.EMClusterModel;
import elki.clustering.em.models.MultivariateGaussianModel;
import elki.data.NumberVector;
import elki.data.model.EMModel;
import elki.math.MathUtil;
import elki.math.linearalgebra.CholeskyDecomposition;
import elki.math.linearalgebra.VMath;
import net.jafama.FastMath;

public class TwoPassMultivariateGaussianModel
implements EMClusterModel<NumberVector, EMModel> {
    double[] mean;
    double[][] covariance;
    CholeskyDecomposition chol;
    double[] tmp;
    double logNorm;
    double logNormDet;
    double weight;
    double wsum;
    double[][] priormatrix;

    public TwoPassMultivariateGaussianModel(double weight, double[] mean) {
        this(weight, mean, null);
    }

    public TwoPassMultivariateGaussianModel(double weight, double[] mean, double[][] covariance) {
        this.weight = weight;
        this.mean = mean;
        this.logNorm = MathUtil.LOGTWOPI * (double)mean.length;
        this.tmp = new double[mean.length];
        this.covariance = covariance != null ? VMath.copy((double[][])covariance) : VMath.identity((int)mean.length, (int)mean.length);
        this.priormatrix = (double[][])(covariance != null ? covariance : null);
        this.wsum = 0.0;
        this.chol = MultivariateGaussianModel.updateCholesky(this.covariance, null);
        this.logNormDet = FastMath.log((double)weight) - 0.5 * this.logNorm - MultivariateGaussianModel.getHalfLogDeterminant(this.chol);
    }

    @Override
    public void beginEStep() {
        this.wsum = 0.0;
        VMath.clear((double[])this.mean);
        VMath.clear((double[][])this.covariance);
    }

    @Override
    public boolean needsTwoPass() {
        return true;
    }

    @Override
    public void firstPassE(NumberVector vec, double wei) {
        assert (vec.getDimensionality() == this.mean.length);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        for (int i = 0; i < this.mean.length; ++i) {
            int n = i;
            this.mean[n] = this.mean[n] + vec.doubleValue(i) * wei;
        }
        this.wsum += wei;
    }

    @Override
    public void finalizeFirstPassE() {
        double s = 1.0 / this.wsum;
        int i = 0;
        while (i < this.mean.length) {
            int n = i++;
            this.mean[n] = this.mean[n] * s;
        }
    }

    @Override
    public void updateE(NumberVector vec, double wei) {
        assert (vec.getDimensionality() == this.mean.length);
        assert (wei >= 0.0 && wei < Double.POSITIVE_INFINITY) : wei;
        if (wei < Double.MIN_NORMAL) {
            return;
        }
        int dim = this.mean.length;
        int i = 0;
        while (i < dim) {
            double vi = this.tmp[i] = vec.doubleValue(i) - this.mean[i];
            double vi_wei = vi * wei;
            double[] cov_i = this.covariance[i];
            for (int j = 0; j < i; ++j) {
                int n = j;
                cov_i[n] = cov_i[n] + vi_wei * this.tmp[j];
            }
            int n = i++;
            cov_i[n] = cov_i[n] + vi_wei * vi;
        }
    }

    @Override
    public void finalizeEStep(double weight, double prior) {
        double f;
        int dim = this.covariance.length;
        this.weight = weight;
        double d = f = this.wsum > Double.MIN_NORMAL && this.wsum < Double.POSITIVE_INFINITY ? 1.0 / this.wsum : 1.0;
        if (prior > 0.0 && this.priormatrix != null) {
            double nu = (double)dim + 2.0;
            double f2 = 1.0 / (this.wsum + prior * (nu + (double)dim + 2.0));
            for (int i = 0; i < dim; ++i) {
                double[] row_i = this.covariance[i];
                double[] pri_i = this.priormatrix[i];
                for (int j = 0; j < i; ++j) {
                    this.covariance[j][i] = row_i[j] = (row_i[j] + prior * pri_i[j]) * f2;
                }
                row_i[i] = (row_i[i] + prior * pri_i[i]) * f2;
            }
        } else {
            int i = 0;
            while (i < dim) {
                double[] row_i = this.covariance[i];
                for (int j = 0; j < i; ++j) {
                    int n = j;
                    double d2 = row_i[n] * f;
                    row_i[n] = d2;
                    this.covariance[j][i] = d2;
                }
                int n = i++;
                row_i[n] = row_i[n] * f;
            }
        }
        this.chol = MultivariateGaussianModel.updateCholesky(this.covariance, null);
        this.logNormDet = FastMath.log((double)weight) - 0.5 * this.logNorm - MultivariateGaussianModel.getHalfLogDeterminant(this.chol);
        if (prior > 0.0 && this.priormatrix == null) {
            this.priormatrix = VMath.copy((double[][])this.covariance);
        }
    }

    public double mahalanobisDistance(NumberVector vec) {
        return VMath.squareSum((double[])this.chol.solveLInplace(VMath.minusEquals((double[])vec.toArray(), (double[])this.mean)));
    }

    @Override
    public double estimateLogDensity(NumberVector vec) {
        return -0.5 * this.mahalanobisDistance(vec) + this.logNormDet;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public EMModel finalizeCluster() {
        return new EMModel(this.mean, this.covariance);
    }
}

