/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.linkage.CentroidLinkage;
import elki.clustering.hierarchical.linkage.Linkage;
import elki.clustering.hierarchical.linkage.SingleLinkage;
import elki.clustering.hierarchical.linkage.WardLinkage;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@References(value={@Reference(authors="L. Kaufman, P. J. Rousseeuw", title="Agglomerative Nesting (Program AGNES)", booktitle="Finding Groups in Data: An Introduction to Cluster Analysis", url="https://doi.org/10.1002/9780470316801.ch5", bibkey="doi:10.1002/9780470316801.ch5"), @Reference(authors="P. H. Sneath", title="The application of computers to taxonomy", booktitle="Journal of general microbiology, 17(1)", url="https://doi.org/10.1099/00221287-17-1-201", bibkey="doi:10.1099/00221287-17-1-201"), @Reference(authors="R. M. Cormack", title="A Review of Classification", booktitle="Journal of the Royal Statistical Society. Series A, Vol. 134, No. 3", url="https://doi.org/10.2307/2344237", bibkey="doi:10.2307/2344237")})
@Alias(value={"HAC", "SAHN"})
public class AGNES<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(AGNES.class);
    protected Distance<? super O> distance;
    protected Linkage linkage = WardLinkage.STATIC;

    public AGNES(Distance<? super O> distance, Linkage linkage) {
        this.distance = distance;
        this.linkage = linkage;
    }

    public ClusterMergeHistory run(Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose((CharSequence)"Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        ClusterDistanceMatrix mat = AGNES.initializeDistanceMatrix(ids, dq, this.linkage);
        return new Instance(this.linkage).run(mat, new ClusterMergeHistoryBuilder(ids, this.distance.isSquared()));
    }

    protected static ClusterDistanceMatrix initializeDistanceMatrix(ArrayDBIDs ids, DistanceQuery<?> dq, Linkage linkage) {
        ClusterDistanceMatrix mat = new ClusterDistanceMatrix(ids.size());
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        double[] matrix = mat.matrix;
        boolean issquare = dq.getDistance().isSquared();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Distance matrix computation", matrix.length, LOG) : null;
        int pos = 0;
        ix.seek(1);
        while (ix.valid()) {
            int x = ix.getOffset();
            assert (pos == ClusterDistanceMatrix.triangleSize(x));
            iy.seek(0);
            while (iy.getOffset() < x) {
                matrix[pos++] = linkage.initial(dq.distance((DBIDRef)ix, (DBIDRef)iy), issquare);
                iy.advance();
            }
            if (prog != null) {
                prog.setProcessed(pos, LOG);
            }
            ix.advance();
        }
        if (prog != null) {
            prog.setProcessed(matrix.length, LOG);
        }
        LOG.ensureCompleted(prog);
        return mat;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID LINKAGE_ID = new OptionID("hierarchical.linkage", "Linkage method to use (e.g., Ward, Single-Link)");
        protected Linkage linkage;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            ((ClassParameter)new ObjectParameter(LINKAGE_ID, Linkage.class).setDefaultValue(WardLinkage.class)).grab(config, x -> {
                this.linkage = x;
            });
            Class defaultD = this.linkage instanceof WardLinkage || this.linkage instanceof CentroidLinkage ? SquaredEuclideanDistance.class : EuclideanDistance.class;
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, defaultD).grab(config, x -> {
                this.distance = x;
            });
        }

        public AGNES<O> make() {
            return new AGNES<O>(this.distance, this.linkage);
        }
    }

    public static class Instance {
        protected Linkage linkage;
        protected ClusterDistanceMatrix mat;
        protected ClusterMergeHistoryBuilder builder;
        protected int end;

        public Instance(Linkage linkage) {
            this.linkage = linkage;
        }

        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)prog);
            }
            LOG.ensureCompleted(prog);
            return builder.complete();
        }

        protected int findMerge() {
            assert (this.end > 0);
            double[] matrix = this.mat.matrix;
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            int ox = 0;
            int xbase = 0;
            while (ox < this.end) {
                if (this.mat.clustermap[ox] >= 0) {
                    assert (xbase == ClusterDistanceMatrix.triangleSize(ox));
                    for (int oy = 0; oy < ox; ++oy) {
                        double dist;
                        if (this.mat.clustermap[oy] < 0 || !((dist = matrix[xbase + oy]) <= mindist)) continue;
                        mindist = dist;
                        x = ox;
                        y = oy;
                    }
                }
                xbase += ox++;
            }
            this.merge(mindist, x, y);
            return x;
        }

        protected void merge(double mindist, int x, int y) {
            assert (x >= 0 && y >= 0);
            assert (y < x);
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, this.linkage.restore(mindist, this.builder.isSquared), yy);
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.mat.clustermap[x] = -1;
            this.updateMatrix(mindist, x, y, sizex, sizey);
        }

        protected void updateMatrix(double mindist, int x, int y, int sizex, int sizey) {
            int jb;
            int j;
            int xbase = ClusterDistanceMatrix.triangleSize(x);
            int ybase = ClusterDistanceMatrix.triangleSize(y);
            double[] scratch = this.mat.matrix;
            for (j = 0; j < y; ++j) {
                if (this.mat.clustermap[j] < 0) continue;
                assert (j < y);
                int yb = ybase + j;
                scratch[yb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[yb], this.builder.getSize(this.mat.clustermap[j]), mindist);
            }
            int jbase = ClusterDistanceMatrix.triangleSize(++j);
            while (j < x) {
                if (this.mat.clustermap[j] >= 0) {
                    jb = jbase + y;
                    scratch[jb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[jb], this.builder.getSize(this.mat.clustermap[j]), mindist);
                }
                jbase += j++;
            }
            jbase += j++;
            while (j < this.end) {
                if (this.mat.clustermap[j] >= 0) {
                    jb = jbase + y;
                    scratch[jb] = this.linkage.combine(sizex, scratch[jbase + x], sizey, scratch[jb], this.builder.getSize(this.mat.clustermap[j]), mindist);
                }
                jbase += j++;
            }
        }

        protected static int shrinkActiveSet(int[] clustermap, int end, int x) {
            if (x == end - 1) {
                while (clustermap[--end - 1] < 0) {
                }
            }
            return end;
        }
    }
}

