/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.math.geometry.PrimsMinimumSpanningTree;
import elki.utilities.datastructures.heap.DoubleLongHeap;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public abstract class AbstractHDBSCAN<O>
implements Algorithm {
    protected final int minPts;
    protected Distance<? super O> distance;

    public AbstractHDBSCAN(Distance<? super O> distance, int minPts) {
        this.distance = distance;
        this.minPts = minPts;
    }

    protected WritableDoubleDataStore computeCoreDists(DBIDs ids, KNNSearcher<DBIDRef> knnQ, int minPts) {
        Logging LOG = this.getLogger();
        WritableDoubleDataStore coredists = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)30);
        FiniteProgress cprog = LOG.isVerbose() ? new FiniteProgress("Computing core sizes", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            coredists.put((DBIDRef)iter, knnQ.getKNN((Object)iter, minPts).getKNNDistance());
            LOG.incrementProcessed((AbstractProgress)cprog);
            iter.advance();
        }
        LOG.ensureCompleted(cprog);
        return coredists;
    }

    protected ClusterMergeHistoryBuilder convertToMergeList(ArrayDBIDs ids, DoubleLongHeap heap, ClusterMergeHistoryBuilder builder) {
        FiniteProgress pprog;
        Logging LOG = this.getLogger();
        FiniteProgress finiteProgress = pprog = LOG.isVerbose() ? new FiniteProgress("Converting MST to pointer representation", heap.size(), LOG) : null;
        while (!heap.isEmpty()) {
            long pair = heap.peekValue();
            int i = (int)(pair >>> 31);
            int j = (int)(pair & Integer.MAX_VALUE);
            builder.add(i, heap.peekKey(), j);
            heap.poll();
            LOG.incrementProcessed((AbstractProgress)pprog);
        }
        LOG.ensureCompleted(pprog);
        return builder;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    protected abstract Logging getLogger();

    public static abstract class Par<O>
    implements Parameterizer {
        public static final OptionID MIN_PTS_ID = new OptionID("hdbscan.minPts", "Threshold for minimum number of points in the epsilon-neighborhood of a point (including this point).");
        protected int minPts;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            ((IntParameter)new IntParameter(MIN_PTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.minPts = x;
            });
        }
    }

    public static class HeapMSTCollector
    implements PrimsMinimumSpanningTree.Collector {
        private DoubleLongHeap heap;
        private FiniteProgress prog;
        private Logging log;

        public HeapMSTCollector(DoubleLongHeap heap, FiniteProgress prog, Logging log) {
            this.heap = heap;
            this.prog = prog;
            this.log = log;
        }

        public void addEdge(double length, int i, int j) {
            this.heap.add(length, (long)i << 31 | (long)j);
            if (this.log != null && this.prog != null) {
                this.log.incrementProcessed((AbstractProgress)this.prog);
            }
        }
    }

    protected static class HDBSCANAdapter
    implements PrimsMinimumSpanningTree.Adapter<ArrayDBIDs> {
        private ArrayDBIDs ids;
        private DBIDArrayIter q;
        private DBIDArrayIter p;
        private DoubleDataStore coredists;
        private DistanceQuery<?> distq;

        public HDBSCANAdapter(ArrayDBIDs ids, DoubleDataStore coredists, DistanceQuery<?> distq) {
            this.ids = ids;
            this.q = ids.iter();
            this.p = ids.iter();
            this.coredists = coredists;
            this.distq = distq;
        }

        public double distance(ArrayDBIDs data, int ip, int iq) {
            this.p.seek(ip);
            this.q.seek(iq);
            double coreP = this.coredists.doubleValue((DBIDRef)this.p);
            double coreQ = this.coredists.doubleValue((DBIDRef)this.q);
            return MathUtil.max((double)coreP, (double)coreQ, (double)this.distq.distance((DBIDRef)this.p, (DBIDRef)this.q));
        }

        public int size(ArrayDBIDs data) {
            assert (data == this.ids);
            return this.ids.size();
        }
    }
}

