/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.AGNES;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.linkage.CentroidLinkage;
import elki.clustering.hierarchical.linkage.Linkage;
import elki.clustering.hierarchical.linkage.SingleLinkage;
import elki.clustering.hierarchical.linkage.WardLinkage;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;

@Reference(authors="M. R. Anderberg", title="Hierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch6")
@Priority(value=200)
public class Anderberg<O>
extends AGNES<O> {
    private static final Logging LOG = Logging.getLogger(Anderberg.class);

    public Anderberg(Distance<? super O> distance, Linkage linkage) {
        super(distance, linkage);
    }

    @Override
    public ClusterMergeHistory run(Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose((CharSequence)"Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        ClusterDistanceMatrix mat = AGNES.initializeDistanceMatrix(ids, dq, this.linkage);
        return new Instance(this.linkage).run(mat, new ClusterMergeHistoryBuilder(ids, this.distance.isSquared()));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        protected Linkage linkage;
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            ((ClassParameter)new ObjectParameter(AGNES.Par.LINKAGE_ID, Linkage.class).setDefaultValue(WardLinkage.class)).grab(config, x -> {
                this.linkage = x;
            });
            Class defaultD = this.linkage instanceof WardLinkage || this.linkage instanceof CentroidLinkage ? SquaredEuclideanDistance.class : EuclideanDistance.class;
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, defaultD).grab(config, x -> {
                this.distance = x;
            });
        }

        public Anderberg<O> make() {
            return new Anderberg<O>(this.distance, this.linkage);
        }
    }

    public static class Instance
    extends AGNES.Instance {
        protected double[] bestd;
        protected int[] besti;

        public Instance(Linkage linkage) {
            super(linkage);
        }

        @Override
        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.bestd = new double[size];
            this.besti = new int[size];
            Instance.initializeNNCache(mat.matrix, this.bestd, this.besti);
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)prog);
            }
            LOG.ensureCompleted(prog);
            return builder.complete();
        }

        protected static void initializeNNCache(double[] scratch, double[] bestd, int[] besti) {
            int size = bestd.length;
            Arrays.fill(bestd, Double.POSITIVE_INFINITY);
            Arrays.fill(besti, -1);
            besti[0] = Integer.MAX_VALUE;
            int p = 0;
            for (int x = 1; x < size; ++x) {
                assert (p == ClusterDistanceMatrix.triangleSize(x));
                double bestdx = Double.POSITIVE_INFINITY;
                int bestix = -1;
                for (int y = 0; y < x; ++y) {
                    int n = p++;
                    double v = scratch[n];
                    if (!(v < bestdx)) continue;
                    bestdx = v;
                    bestix = y;
                }
                assert (0 <= bestix && bestix < x);
                bestd[x] = bestdx;
                besti[x] = bestix;
            }
        }

        @Override
        protected int findMerge() {
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            for (int cx = 1; cx < this.end; ++cx) {
                double dist;
                int cy = this.besti[cx];
                if (cy < 0 || !((dist = this.bestd[cx]) <= mindist)) continue;
                mindist = dist;
                x = cx;
                y = cy;
            }
            this.merge(mindist, x, y);
            return x;
        }

        @Override
        protected void merge(double mindist, int x, int y) {
            assert (y < x);
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, this.linkage.restore(mindist, this.builder.isSquared), yy);
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.besti[x] = -1;
            this.mat.clustermap[x] = -1;
            this.updateMatrix(mindist, x, y, sizex, sizey);
            if (y > 0) {
                Instance.findBest(this.mat.matrix, this.bestd, this.besti, y);
            }
        }

        @Override
        protected void updateMatrix(double mindist, int x, int y, int sizex, int sizey) {
            double d;
            int sizej;
            int j;
            int xbase = ClusterDistanceMatrix.triangleSize(x);
            int ybase = ClusterDistanceMatrix.triangleSize(y);
            double[] scratch = this.mat.matrix;
            for (j = 0; j < y; ++j) {
                if (this.mat.clustermap[j] < 0) continue;
                int sizej2 = this.builder.getSize(this.mat.clustermap[j]);
                int yb = ybase + j;
                double d2 = scratch[yb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[yb], sizej2, mindist);
                Instance.updateCache(scratch, this.bestd, this.besti, x, y, j, d2);
            }
            int jbase = ClusterDistanceMatrix.triangleSize(++j);
            while (j < x) {
                if (this.mat.clustermap[j] >= 0) {
                    sizej = this.builder.getSize(this.mat.clustermap[j]);
                    int jb = jbase + y;
                    d = scratch[jb] = this.linkage.combine(sizex, scratch[xbase + j], sizey, scratch[jb], sizej, mindist);
                    Instance.updateCache(scratch, this.bestd, this.besti, x, y, j, d);
                }
                jbase += j++;
            }
            jbase += j++;
            while (j < this.end) {
                if (this.mat.clustermap[j] >= 0) {
                    sizej = this.builder.getSize(this.mat.clustermap[j]);
                    int jb = jbase + y;
                    d = scratch[jb] = this.linkage.combine(sizex, scratch[jbase + x], sizey, scratch[jb], sizej, mindist);
                    Instance.updateCache(scratch, this.bestd, this.besti, x, y, j, d);
                }
                jbase += j++;
            }
        }

        protected static void updateCache(double[] scratch, double[] bestd, int[] besti, int x, int y, int j, double d) {
            assert (y < x);
            if (y < j && d <= bestd[j]) {
                bestd[j] = d;
                besti[j] = y;
                return;
            }
            if (besti[j] == x || besti[j] == y) {
                Instance.findBest(scratch, bestd, besti, j);
            }
        }

        protected static void findBest(double[] scratch, double[] bestd, int[] besti, int j) {
            double bestdj = Double.POSITIVE_INFINITY;
            int bestij = -1;
            int i = 0;
            int o = ClusterDistanceMatrix.triangleSize(j);
            while (i < j) {
                double dist;
                if (besti[i] >= 0 && (dist = scratch[o]) <= bestdj) {
                    bestdj = dist;
                    bestij = i;
                }
                ++i;
                ++o;
            }
            assert (bestij < j);
            bestd[j] = bestdj;
            besti[j] = bestij;
        }
    }
}

