/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.SLINK;
import elki.database.datastore.DBIDDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="D. Defays", title="An Efficient Algorithm for the Complete Link Cluster Method", booktitle="The Computer Journal 20.4", url="https://doi.org/10.1093/comjnl/20.4.364", bibkey="DBLP:journals/cj/Defays77")
@Alias(value={"Defays"})
public class CLINK<O>
extends SLINK<O> {
    private static final Logging LOG = Logging.getLogger(CLINK.class);

    public CLINK(Distance<? super O> distance) {
        super(distance);
    }

    @Override
    protected void process(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        this.clinkstep3(it, n, pi, lambda, m);
        this.clinkstep4567(id, ids, it, n, pi, lambda, m);
        this.clinkstep8(id, it, n, pi, lambda);
    }

    private void clinkstep3(DBIDArrayIter i, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        i.seek(0);
        while (i.getOffset() < n) {
            double m_i;
            double l_i = lambda.doubleValue((DBIDRef)i);
            if (l_i < (m_i = m.doubleValue((DBIDRef)i))) {
                p_i.from((DBIDDataStore)pi, (DBIDRef)i);
                double mp_i = m.doubleValue((DBIDRef)p_i);
                if (mp_i < m_i) {
                    m.putDouble((DBIDRef)p_i, m_i);
                }
                m.putDouble((DBIDRef)i, Double.POSITIVE_INFINITY);
            }
            i.advance();
        }
    }

    private void clinkstep4567(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDArrayIter a = ids.iter().seek(n - 1);
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(n - 1);
        while (it.valid()) {
            double mp_i;
            double l_i = lambda.doubleValue((DBIDRef)it);
            if (l_i >= (mp_i = m.doubleValue((DBIDRef)p_i.from((DBIDDataStore)pi, (DBIDRef)it)))) {
                if (m.doubleValue((DBIDRef)it) < m.doubleValue((DBIDRef)a)) {
                    a.seek(it.getOffset());
                }
            } else {
                m.putDouble((DBIDRef)it, Double.POSITIVE_INFINITY);
            }
            it.retract();
        }
        DBIDVar b = DBIDUtil.newVar().from((DBIDDataStore)pi, (DBIDRef)a);
        double c = lambda.doubleValue((DBIDRef)a);
        pi.putDBID((DBIDRef)a, id);
        lambda.putDouble((DBIDRef)a, m.doubleValue((DBIDRef)a));
        if (a.getOffset() < n - 1) {
            DBIDVar last = DBIDUtil.newVar((DBIDRef)it.seek(n - 1));
            DBIDVar d = DBIDUtil.newVar();
            while (!DBIDUtil.equal((DBIDRef)b, (DBIDRef)id)) {
                if (DBIDUtil.equal((DBIDRef)b, (DBIDRef)last)) {
                    pi.putDBID((DBIDRef)b, id);
                    lambda.putDouble((DBIDRef)b, c);
                    break;
                }
                d.from((DBIDDataStore)pi, (DBIDRef)b);
                pi.putDBID((DBIDRef)b, id);
                c = lambda.putDouble((DBIDRef)b, c);
                b.set((DBIDRef)d);
            }
        }
    }

    private void clinkstep8(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDVar pp_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            p_i.from((DBIDDataStore)pi, (DBIDRef)it);
            pp_i.from((DBIDDataStore)pi, (DBIDRef)p_i);
            if (DBIDUtil.equal((DBIDRef)pp_i, (DBIDRef)id) && lambda.doubleValue((DBIDRef)it) >= lambda.doubleValue((DBIDRef)p_i)) {
                pi.putDBID((DBIDRef)it, id);
            }
            it.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
        }

        public CLINK<O> make() {
            return new CLINK<O>(this.distance);
        }
    }
}

