/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.math.MathUtil;
import elki.utilities.exceptions.AbortException;

public class ClusterDistanceMatrix {
    public final double[] matrix;
    public final int[] clustermap;
    public final int size;

    public ClusterDistanceMatrix(int size) {
        this.size = size;
        if (size > 65536) {
            throw new AbortException("This implementation does not scale to data sets larger than 65536 instances (~16 GB RAM), at which point the Java maximum array size is reached.");
        }
        this.matrix = new double[ClusterDistanceMatrix.triangleSize(size)];
        this.clustermap = MathUtil.sequence((int)0, (int)size);
    }

    public static int triangleSize(int x) {
        return x * (x - 1) >>> 1;
    }

    public double get(int x, int y) {
        return x == y ? 0.0 : (x < y ? this.matrix[ClusterDistanceMatrix.triangleSize(y) + x] : this.matrix[ClusterDistanceMatrix.triangleSize(x) + y]);
    }
}

