/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDVar;

public class ClusterMergeHistory {
    protected ArrayDBIDs ids;
    protected double[] distances;
    protected int[] sizes;
    protected int[] merges;
    protected int[] positions;
    boolean isSquared;

    public ClusterMergeHistory(ArrayDBIDs ids, int[] merges, double[] distances, int[] sizes, boolean isSquared) {
        this.ids = ids;
        this.merges = merges;
        this.distances = distances;
        this.sizes = sizes;
        this.isSquared = isSquared;
        assert (distances.length << 1 == merges.length);
        assert (sizes == null || distances.length == sizes.length);
    }

    public DBIDVar assignVar(int i, DBIDVar var) {
        assert (i >= 0 && i < this.ids.size()) : "Can only assign the first N singleton clusters.";
        return this.ids.assignVar(i, var);
    }

    public int getMergeA(int i) {
        return this.merges[i << 1];
    }

    public int getMergeB(int i) {
        return this.merges[(i << 1) + 1];
    }

    public double getMergeHeight(int i) {
        return this.distances[i];
    }

    public int getSize(int i) {
        return this.sizes[i];
    }

    public int size() {
        return this.ids.size();
    }

    public int numMerges() {
        return this.merges.length >> 1;
    }

    public boolean isSquared() {
        return this.isSquared;
    }

    public ArrayDBIDs getDBIDs() {
        return this.ids;
    }

    public int[] getPositions() {
        if (this.positions != null) {
            return this.positions;
        }
        int n = this.ids.size();
        this.positions = new int[n];
        int[] cpos = new int[this.sizes.length];
        for (int i = this.sizes.length - 1; i >= 0; --i) {
            int sa;
            int a = this.merges[i << 1];
            int b = this.merges[(i << 1) + 1];
            int c = cpos[i];
            int n2 = sa = a < n ? 1 : this.sizes[a - n];
            if (a < n) {
                this.positions[a] = c;
            } else {
                cpos[a - n] = c;
            }
            if (b < n) {
                this.positions[b] = c + sa;
                continue;
            }
            cpos[b - n] = c + sa;
        }
        return this.positions;
    }
}

