/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.ClusterDensityMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.logging.Logging;
import elki.math.MathUtil;
import elki.utilities.datastructures.arrays.IntegerArrayQuickSort;
import java.util.Arrays;

public class ClusterMergeHistoryBuilder {
    private static final Logging LOG = Logging.getLogger(ClusterMergeHistoryBuilder.class);
    protected final ArrayDBIDs ids;
    protected double[] mergeDistance;
    protected int[] csize;
    protected int[] merges;
    protected int[] parent;
    protected int mergecount = 0;
    protected ArrayModifiableDBIDs prototypes;
    protected boolean isSquared;

    public ClusterMergeHistoryBuilder(ArrayDBIDs ids, boolean isSquared) {
        this.ids = ids;
        int n = ids.size();
        this.mergeDistance = new double[n - 1];
        this.csize = new int[n - 1];
        this.merges = new int[n - 1 << 1];
        this.isSquared = isSquared;
    }

    public int add(int i, double dist, int j) {
        int tmp;
        if (this.parent == null) {
            assert (this.mergecount == 0);
            this.parent = MathUtil.sequence((int)0, (int)((this.ids.size() << 1) - 1));
        }
        int t = this.mergecount + this.ids.size();
        int p = this.parent[i];
        while (i != p) {
            tmp = this.parent[p];
            this.parent[i] = t;
            i = p;
            p = tmp;
        }
        p = this.parent[j];
        while (j != p) {
            tmp = this.parent[p];
            this.parent[j] = t;
            j = p;
            p = tmp;
        }
        this.parent[i] = this.parent[j] = this.strictAdd(i, dist, j);
        int t2 = this.parent[j];
        assert (t == t2);
        return t2;
    }

    public int strictAdd(int source, double distance, int target) {
        int n = this.ids.size();
        assert (source >= 0 && target >= 0);
        assert (source < n + this.mergecount && target < n + this.mergecount);
        assert (this.prototypes == null);
        assert (source != target);
        int size = (source < n ? 1 : this.csize[source - n]) + (target < n ? 1 : this.csize[target - n]);
        this.mergeDistance[this.mergecount] = distance;
        this.csize[this.mergecount] = size;
        this.merges[this.mergecount << 1] = source;
        this.merges[(this.mergecount << 1) + 1] = target;
        return this.mergecount++ + n;
    }

    public int strictAdd(int source, double distance, int target, DBIDRef prototype) {
        int n = this.ids.size();
        if (this.mergecount == 0) {
            this.prototypes = DBIDUtil.newArray((int)(n - 1));
        }
        assert (source >= 0 && target >= 0);
        assert (source < n + this.mergecount && target < n + this.mergecount);
        assert (this.prototypes != null);
        assert (source != target);
        int size = (source < n ? 1 : this.csize[source - n]) + (target < n ? 1 : this.csize[target - n]);
        this.mergeDistance[this.mergecount] = distance;
        this.csize[this.mergecount] = size;
        this.merges[this.mergecount << 1] = source;
        this.merges[(this.mergecount << 1) + 1] = target;
        this.prototypes.add(prototype);
        return this.mergecount++ + n;
    }

    public ClusterMergeHistory complete() {
        if (this.mergecount != this.ids.size() - 1) {
            LOG.warning((CharSequence)(this.mergecount + " merges were added to the hierarchy, expected " + (this.ids.size() - 1)));
        }
        return this.prototypes != null ? new ClusterPrototypeMergeHistory(this.ids, this.merges, this.mergeDistance, this.csize, this.isSquared, (ArrayDBIDs)this.prototypes) : new ClusterMergeHistory(this.ids, this.merges, this.mergeDistance, this.csize, this.isSquared);
    }

    public ClusterDensityMergeHistory complete(WritableDoubleDataStore coredists) {
        if (this.mergecount != this.ids.size() - 1) {
            LOG.warning((CharSequence)(this.mergecount + " merges were added to the hierarchy, expected " + (this.ids.size() - 1)));
        }
        return new ClusterDensityMergeHistory(this.ids, this.merges, this.mergeDistance, this.csize, this.isSquared, (DoubleDataStore)coredists);
    }

    public int getSize(int id) {
        return id < this.ids.size() ? 1 : this.csize[id - this.ids.size()];
    }

    public void setSize(int id, int size) {
        assert (id >= this.ids.size());
        this.csize[id - this.ids.size()] = size;
    }

    public int[] optimizeOrder() {
        if (this.checkMonotone()) {
            return null;
        }
        int m = this.mergecount;
        int n = this.ids.size();
        int[] o1 = MathUtil.sequence((int)0, (int)m);
        IntegerArrayQuickSort.sort((int[])o1, (a, b) -> {
            int sa = this.csize[a];
            int sb = this.csize[b];
            if (sa < sb) {
                return -1;
            }
            if (sa > sb) {
                return 1;
            }
            double da = this.mergeDistance[a];
            double db = this.mergeDistance[b];
            return da < db ? -1 : (da > db ? 1 : (a > b ? -1 : 1));
        });
        byte[] seen = new byte[m];
        int[] order = new int[m];
        int size = 0;
        for (int it : o1) {
            if (seen[it] > 0) continue;
            size = this.addRecursive(order, size, seen, it, n);
            int n2 = size++;
            int n3 = it;
            order[n2] = n3;
            seen[n3] = 1;
        }
        assert (size == m);
        double[] md2 = new double[this.mergeDistance.length];
        int[] csize2 = new int[this.csize.length];
        int[] merges2 = new int[this.merges.length];
        ArrayModifiableDBIDs prototypes2 = this.prototypes == null ? null : DBIDUtil.newArray((int)this.csize.length);
        DBIDVar tmp = this.prototypes == null ? null : DBIDUtil.newVar();
        int[] reverse = new int[m];
        Arrays.fill(reverse, -1);
        for (int i = 0; i < m; ++i) {
            int oi = order[i];
            int a2 = this.merges[oi << 1];
            int b2 = this.merges[(oi << 1) + 1];
            reverse[oi] = i;
            assert (a2 < n || reverse[a2 - n] >= 0);
            int n4 = merges2[i << 1] = a2 < n ? a2 : reverse[a2 - n] + n;
            assert (b2 < n || reverse[b2 - n] >= 0);
            merges2[(i << 1) + 1] = b2 < n ? b2 : reverse[b2 - n] + n;
            md2[i] = this.mergeDistance[oi];
            csize2[i] = this.csize[oi];
            if (this.prototypes == null) continue;
            prototypes2.add((DBIDRef)prototypes2.assignVar(oi, tmp));
        }
        this.mergeDistance = md2;
        this.csize = csize2;
        this.merges = merges2;
        this.parent = null;
        this.prototypes = prototypes2;
        return reverse;
    }

    private boolean checkMonotone() {
        double cur = this.mergeDistance.length > 0 ? this.mergeDistance[0] : Double.NaN;
        for (int i = 1; i < this.mergeDistance.length; ++i) {
            double next = this.mergeDistance[i];
            if (next < cur) {
                return false;
            }
            cur = next;
        }
        return true;
    }

    private int addRecursive(int[] order, int size, byte[] seen, int it, int n) {
        int a = this.merges[it << 1] - n;
        int b = this.merges[(it << 1) + 1] - n;
        if (a >= 0 && seen[a] == 0) {
            size = this.addRecursive(order, size, seen, a, n);
            int n2 = size++;
            int n3 = a;
            order[n2] = n3;
            seen[n3] = 1;
        }
        if (b >= 0 && seen[b] == 0) {
            size = this.addRecursive(order, size, seen, b, n);
            int n4 = size++;
            int n5 = b;
            order[n4] = n5;
            seen[n5] = 1;
        }
        return size;
    }
}

