/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.Anderberg;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.MiniMax;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.EnumParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@Reference(authors="Erich Schubert", title="HACAM: Hierarchical Agglomerative Clustering Around Medoids - and its Limitations", booktitle="Proc. Conf. \"Lernen, Wissen, Daten, Analysen\", LWDA", url="http://ceur-ws.org/Vol-2993/paper-19.pdf", bibkey="DBLP:conf/lwa/Schubert21")
public class HACAM<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(HACAM.class);
    protected Distance<? super O> distance;
    protected Variant variant;

    public HACAM(Distance<? super O> distance, Variant variant) {
        this.distance = distance;
        this.variant = variant;
    }

    public ClusterPrototypeMergeHistory run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).precomputed().distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ArrayModifiableDBIDs prots = DBIDUtil.newArray((int)ClusterDistanceMatrix.triangleSize(ids.size()));
        ClusterDistanceMatrix mat = MiniMax.initializeMatrices(ids, prots, dq);
        return new Instance(this.variant).run(ids, mat, new ClusterMergeHistoryBuilder(ids, dq.getDistance().isSquared()), dq, prots.iter());
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID VARIANT_ID = new OptionID("hacam.variant", "Variant of the algorithm to use.");
        protected Distance<? super O> distance;
        protected Variant variant;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new EnumParameter(VARIANT_ID, Variant.class, (Enum)Variant.MINIMUM_SUM_INCREASE).grab(config, x -> {
                this.variant = x;
            });
        }

        public HACAM<O> make() {
            return new HACAM<O>(this.distance, this.variant);
        }
    }

    public static class Instance
    extends Anderberg.Instance {
        protected Variant variant;
        protected Int2ObjectOpenHashMap<ModifiableDBIDs> clusters;
        protected double[] tds;
        protected DistanceQuery<?> dq;
        protected DBIDArrayMIter prots;
        protected DBIDArrayIter ix;
        protected DBIDArrayIter iy;

        public Instance(Variant variant) {
            super(null);
            this.variant = variant;
        }

        @Override
        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            throw new IllegalStateException("Need prototypes.");
        }

        public ClusterPrototypeMergeHistory run(ArrayDBIDs ids, ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder, DistanceQuery<?> dq, DBIDArrayMIter prots) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.clusters = new Int2ObjectOpenHashMap(size);
            this.ix = ids.iter();
            this.iy = ids.iter();
            this.prots = prots;
            this.tds = this.variant == Variant.MINIMUM_SUM_INCREASE ? new double[size] : null;
            this.dq = dq;
            this.bestd = new double[size];
            this.besti = new int[size];
            Instance.initializeNNCache(mat.matrix, this.bestd, this.besti);
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("HACAM clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)prog);
            }
            LOG.ensureCompleted(prog);
            return (ClusterPrototypeMergeHistory)builder.complete();
        }

        @Override
        protected int findMerge() {
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            for (int cx = 0; cx < this.end; ++cx) {
                double dist;
                int cy = this.besti[cx];
                if (cy < 0 || !((dist = this.bestd[cx]) <= mindist)) continue;
                mindist = dist;
                x = cx;
                y = cy;
            }
            assert (x >= 0 && y >= 0);
            if (y > x) {
                int tmp = x;
                x = y;
                y = tmp;
            }
            this.merge(x, y);
            return x;
        }

        protected void merge(int x, int y) {
            assert (x >= 0 && y >= 0);
            assert (y < x);
            double[] distances = this.mat.matrix;
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            if (cy == null) {
                cy = DBIDUtil.newArray();
                cy.add((DBIDRef)this.iy.seek(y));
            }
            if (cx == null) {
                cy.add((DBIDRef)this.ix.seek(x));
            } else {
                cy.addDBIDs((DBIDs)cx);
                this.clusters.remove(x);
            }
            this.clusters.put(y, (Object)cy);
            if (this.tds != null) {
                this.tds[y] = distances[offset] + this.tds[x] + this.tds[y];
            }
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, distances[offset], yy, (DBIDRef)this.prots.seek(offset));
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.mat.clustermap[x] = -1;
            this.besti[x] = -1;
            this.updateMatrices(x, y);
            if (this.besti[y] == x) {
                Instance.findBest(distances, this.bestd, this.besti, y);
            }
        }

        private void updateMatrices(int x, int y) {
            int b;
            double[] distances = this.mat.matrix;
            int a = y;
            int yoffset = ClusterDistanceMatrix.triangleSize(y);
            for (b = 0; b < a; ++b) {
                if (this.mat.clustermap[b] < 0) continue;
                this.updateEntry(a, b);
                Instance.updateCache(distances, this.bestd, this.besti, x, y, b, distances[yoffset + b]);
            }
            b = y;
            for (a = y + 1; a < this.end; ++a) {
                if (this.mat.clustermap[a] < 0) continue;
                this.updateEntry(a, b);
                Instance.updateCache(distances, this.bestd, this.besti, x, y, a, distances[ClusterDistanceMatrix.triangleSize(a) + y]);
            }
        }

        protected void updateEntry(int x, int y) {
            double minMaxDist;
            assert (y < x);
            double[] distances = this.mat.matrix;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            DBIDVar prototype = DBIDUtil.newVar((DBIDRef)this.ix.seek(x));
            if (cx != null && cy != null) {
                minMaxDist = Instance.findPrototype(this.dq, (DBIDs)cx, (DBIDs)cy, prototype, Double.POSITIVE_INFINITY);
                minMaxDist = Instance.findPrototype(this.dq, (DBIDs)cy, (DBIDs)cx, prototype, minMaxDist);
            } else if (cx != null) {
                minMaxDist = Instance.findPrototypeSingleton(this.dq, (DBIDs)cx, (DBIDRef)this.iy.seek(y), prototype);
            } else if (cy != null) {
                minMaxDist = Instance.findPrototypeSingleton(this.dq, (DBIDs)cy, (DBIDRef)this.ix.seek(x), prototype);
            } else {
                minMaxDist = this.dq.distance((DBIDRef)this.ix.seek(x), (DBIDRef)this.iy.seek(y));
                prototype.set((DBIDRef)this.ix);
            }
            if (this.tds != null) {
                minMaxDist -= this.tds[x] + this.tds[y];
            }
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            distances[offset] = minMaxDist;
            this.prots.seek(offset).setDBID((DBIDRef)prototype);
        }

        private static double findPrototype(DistanceQuery<?> dq, DBIDs cx, DBIDs cy, DBIDVar prototype, double minDistSum) {
            DBIDIter i = cx.iter();
            while (i.valid()) {
                double distsum = Instance.distanceSum(dq, i, cy, 0.0, minDistSum);
                if (!(distsum >= minDistSum) && (distsum = Instance.distanceSum(dq, i, cx, distsum, minDistSum)) < minDistSum) {
                    minDistSum = distsum;
                    prototype.set((DBIDRef)i);
                }
                i.advance();
            }
            return minDistSum;
        }

        private static double findPrototypeSingleton(DistanceQuery<?> dq, DBIDs cx, DBIDRef cy, DBIDVar prototype) {
            double sumDisty = 0.0;
            double minDistSum = Double.POSITIVE_INFINITY;
            DBIDIter i = cx.iter();
            while (i.valid()) {
                double distsum = dq.distance((DBIDRef)i, cy);
                sumDisty += distsum;
                if (!(distsum >= minDistSum) && (distsum = Instance.distanceSum(dq, i, cx, distsum, minDistSum)) < minDistSum) {
                    minDistSum = distsum;
                    prototype.set((DBIDRef)i);
                }
                i.advance();
            }
            if (sumDisty < minDistSum) {
                minDistSum = sumDisty;
                prototype.set(cy);
            }
            return minDistSum;
        }

        private static double distanceSum(DistanceQuery<?> dq, DBIDIter i, DBIDs cy, double distsum, double minDistSum) {
            DBIDIter j = cy.iter();
            while (j.valid()) {
                if ((distsum += dq.distance((DBIDRef)i, (DBIDRef)j)) >= minDistSum) {
                    return distsum;
                }
                j.advance();
            }
            return distsum;
        }
    }

    public static enum Variant {
        MINIMUM_SUM,
        MINIMUM_SUM_INCREASE;

    }
}

