/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.AbstractHDBSCAN;
import elki.clustering.hierarchical.ClusterDensityMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.FiniteProgress;
import elki.math.geometry.PrimsMinimumSpanningTree;
import elki.utilities.datastructures.heap.DoubleLongHeap;
import elki.utilities.datastructures.heap.DoubleLongMinHeap;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;

@Title(value="HDBSCAN: Hierarchical Density-Based Spatial Clustering of Applications with Noise")
@Description(value="Density-Based Clustering Based on Hierarchical Density Estimates")
@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public class HDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(HDBSCANLinearMemory.class);

    public HDBSCANLinearMemory(Distance<? super O> distance, int minPts) {
        super(distance, minPts);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public ClusterDensityMergeHistory run(Relation<O> relation) {
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        KNNSearcher knnQ = qb.kNNByDBID(this.minPts);
        DistanceQuery distQ = qb.distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        WritableDoubleDataStore coredists = this.computeCoreDists((DBIDs)ids, (KNNSearcher<DBIDRef>)knnQ, this.minPts);
        int numedges = ids.size() - 1;
        DoubleLongMinHeap heap = new DoubleLongMinHeap(numedges);
        FiniteProgress mprog = LOG.isVerbose() ? new FiniteProgress("Computing minimum spanning tree (n-1 edges)", numedges, LOG) : null;
        PrimsMinimumSpanningTree.processDense((Object)ids, (PrimsMinimumSpanningTree.Adapter)new AbstractHDBSCAN.HDBSCANAdapter(ids, (DoubleDataStore)coredists, distQ), (PrimsMinimumSpanningTree.Collector)new AbstractHDBSCAN.HeapMSTCollector((DoubleLongHeap)heap, mprog, LOG));
        LOG.ensureCompleted(mprog);
        return this.convertToMergeList(ids, (DoubleLongHeap)heap, new ClusterMergeHistoryBuilder(ids, distQ.getDistance().isSquared())).complete(coredists);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends AbstractHDBSCAN.Par<O> {
        public HDBSCANLinearMemory<O> make() {
            return new HDBSCANLinearMemory(this.distance, this.minPts);
        }
    }
}

