/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.AGNES;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.NNChain;
import elki.clustering.hierarchical.linkage.GeometricLinkage;
import elki.clustering.hierarchical.linkage.WardLinkage;
import elki.data.NumberVector;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.relation.Relation;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ClassParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="F. Murtagh", booktitle="Multidimensional Clustering Algorithms", title="Multidimensional Clustering Algorithms", url="http://www.multiresolutions.com/strule/MClA/", bibkey="books/Murtagh85")
public class LinearMemoryNNChain<O extends NumberVector>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(LinearMemoryNNChain.class);
    private GeometricLinkage linkage;

    public LinearMemoryNNChain(GeometricLinkage linkage) {
        this.linkage = linkage;
    }

    public ClusterMergeHistory run(Relation<O> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ClusterMergeHistoryBuilder builder = new ClusterMergeHistoryBuilder(ids, true);
        return new Instance<O>(this.linkage).run(ids, relation, builder);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public static class Par<O extends NumberVector>
    implements Parameterizer {
        public static final OptionID LINKAGE_ID = AGNES.Par.LINKAGE_ID;
        protected GeometricLinkage linkage = WardLinkage.STATIC;

        public void configure(Parameterization config) {
            ((ClassParameter)new ObjectParameter(LINKAGE_ID, GeometricLinkage.class).setDefaultValue(WardLinkage.class)).grab(config, x -> {
                this.linkage = x;
            });
        }

        public LinearMemoryNNChain<O> make() {
            return new LinearMemoryNNChain(this.linkage);
        }
    }

    public static class Instance<O extends NumberVector> {
        private GeometricLinkage linkage;

        public Instance(GeometricLinkage linkage) {
            this.linkage = linkage;
        }

        public ClusterMergeHistory run(ArrayDBIDs ids, Relation<O> relation, ClusterMergeHistoryBuilder builder) {
            DBIDArrayIter it = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            this.nnChainCore(it, it2, builder, relation);
            builder.optimizeOrder();
            return builder.complete();
        }

        private void nnChainCore(DBIDArrayIter aIt, DBIDArrayIter aIt2, ClusterMergeHistoryBuilder builder, Relation<O> rel) {
            int size = rel.size();
            boolean warnedIrreducible = false;
            IntegerArray chain = new IntegerArray(size << 1);
            int[] clustermap = MathUtil.sequence((int)0, (int)size);
            double[][] clusters = new double[rel.size()][];
            int t = 0;
            aIt.seek(0);
            while (aIt.valid()) {
                clusters[t++] = ((NumberVector)rel.get((DBIDRef)aIt)).toArray();
                aIt.advance();
            }
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running LinearMemoryNNChain", size - 1, LOG) : null;
            int end = size;
            for (int k = 1; k < size; ++k) {
                int a = -1;
                int b = -1;
                if (chain.size() < 2) {
                    a = NNChain.Instance.findUnlinked(0, end, clustermap);
                    b = NNChain.Instance.findUnlinked(a + 1, end, clustermap);
                    assert (clustermap[a] >= 0 && clustermap[b] >= 0);
                    chain.clear();
                    chain.add(a);
                } else {
                    a = chain.get(chain.size - 2);
                    b = chain.get(chain.size - 1);
                    assert (clustermap[b] >= 0);
                    if (clustermap[a] < 0) {
                        if (!warnedIrreducible) {
                            LOG.warning((CharSequence)"Detected an inversion in the clustering. NNChain on irreducible linkages may yield different results.");
                            warnedIrreducible = true;
                        }
                        chain.size -= 2;
                        --k;
                        continue;
                    }
                    --chain.size;
                }
                int bSize = builder.getSize(b);
                double minDist = this.linkage.distance(clusters[a], builder.getSize(a), clusters[b], bSize);
                do {
                    int aSize = builder.getSize(a);
                    int c = b;
                    for (int i = 0; i < end; ++i) {
                        double dist;
                        if (i == a || i == b || clustermap[i] < 0 || !((dist = this.linkage.distance(clusters[a], aSize, clusters[i], builder.getSize(i))) < minDist)) continue;
                        minDist = dist;
                        c = i;
                    }
                    b = a;
                    a = c;
                    chain.add(a);
                } while (chain.size() < 3 || a != chain.get(chain.size - 1 - 2));
                if (a < b) {
                    int tmp = a;
                    a = b;
                    b = tmp;
                }
                assert (minDist == this.linkage.distance(clusters[a], builder.getSize(a), clusters[b], builder.getSize(b)));
                this.merge(size, clusters, builder, clustermap, minDist, a, b);
                end = AGNES.Instance.shrinkActiveSet(clustermap, end, a);
                chain.size -= 3;
                chain.add(b);
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
        }

        protected void merge(int end, double[][] clusters, ClusterMergeHistoryBuilder builder, int[] clustermap, double mindist, int x, int y) {
            assert (x >= 0 && y >= 0);
            int xx = clustermap[x];
            int yy = clustermap[y];
            int sizex = builder.getSize(xx);
            int sizey = builder.getSize(yy);
            int zz = builder.strictAdd(xx, this.linkage.restore(mindist, builder.isSquared), yy);
            assert (builder.getSize(zz) == sizex + sizey);
            clustermap[y] = zz;
            clustermap[x] = -1;
            clusters[y] = this.linkage.merge(clusters[x], sizex, clusters[y], sizey);
        }
    }
}

