/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.AGNES;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.linkage.SingleLinkage;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@References(value={@Reference(authors="D. Herr, Q. Han, S. Lohmann, T. Ertl", title="Visual clutter reduction through hierarchy-based projection of high-dimensional labeled data", booktitle="Graphics Interface Conference", url="https://doi.org/10.20380/GI2016.14", bibkey="DBLP:conf/graphicsinterface/HerrHLE16"), @Reference(authors="S. Miyamoto, Y. Kaizu, Y. Endo", title="Hierarchical and non-hierarchical medoid clustering using asymmetric similarity measures", booktitle="Soft Computing and Intelligent Systems (SCIS) and Int. Symp. Advanced Intelligent Systems (ISIS)", url="https://doi.org/10.1109/SCIS-ISIS.2016.0091", bibkey="DBLP:conf/scisisis/MiyamotoKE16")})
public class MedoidLinkage<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(MedoidLinkage.class);
    protected Distance<? super O> distance;

    public MedoidLinkage(Distance<? super O> distance) {
        this.distance = distance;
    }

    public ClusterPrototypeMergeHistory run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).precomputed().distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ClusterDistanceMatrix mat = AGNES.initializeDistanceMatrix(ids, dq, SingleLinkage.STATIC);
        return new Instance().run(ids, mat, new ClusterMergeHistoryBuilder(ids, this.distance.isSquared()), dq);
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
        }

        public MedoidLinkage<O> make() {
            return new MedoidLinkage<O>(this.distance);
        }
    }

    public static class Instance
    extends AGNES.Instance {
        protected Int2ObjectOpenHashMap<ModifiableDBIDs> clusters;
        protected DistanceQuery<?> dq;
        protected DBIDArrayMIter mi;
        protected DBIDArrayMIter mj;
        protected DBIDArrayIter ix;
        protected DBIDArrayIter iy;

        public Instance() {
            super(null);
        }

        @Override
        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            throw new IllegalStateException("Need prototypes.");
        }

        public ClusterPrototypeMergeHistory run(ArrayDBIDs ids, ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder, DistanceQuery<?> dq) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.clusters = new Int2ObjectOpenHashMap(size);
            this.ix = ids.iter();
            this.iy = ids.iter();
            ArrayModifiableDBIDs medoids = DBIDUtil.newArray((DBIDs)ids);
            this.mi = medoids.iter();
            this.mj = medoids.iter();
            this.dq = dq;
            FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Medoid linkage clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)prog);
            }
            LOG.ensureCompleted(prog);
            return (ClusterPrototypeMergeHistory)builder.complete();
        }

        @Override
        protected int findMerge() {
            double[] distances = this.mat.matrix;
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            for (int dx = 0; dx < this.end; ++dx) {
                if (this.mat.clustermap[dx] < 0) continue;
                int xoffset = ClusterDistanceMatrix.triangleSize(dx);
                for (int dy = 0; dy < dx; ++dy) {
                    double dist;
                    if (this.mat.clustermap[dy] < 0 || !((dist = distances[xoffset + dy]) < mindist)) continue;
                    mindist = dist;
                    x = dx;
                    y = dy;
                }
            }
            this.merge(x, y);
            return x;
        }

        protected void merge(int x, int y) {
            assert (x >= 0 && y >= 0);
            assert (y < x);
            double[] distances = this.mat.matrix;
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            if (cy == null) {
                cy = DBIDUtil.newArray();
                cy.add((DBIDRef)this.iy.seek(y));
            }
            if (cx == null) {
                cy.add((DBIDRef)this.ix.seek(x));
            } else {
                cy.addDBIDs((DBIDs)cx);
                this.clusters.remove(x);
            }
            this.clusters.put(y, (Object)cy);
            Instance.findMedoid(this.dq, (DBIDs)cy, this.mj.seek(y));
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, distances[offset], yy, (DBIDRef)this.mj);
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.mat.clustermap[x] = -1;
            this.updateMatrix(x, y);
        }

        private static double findMedoid(DistanceQuery<?> dq, DBIDs c, DBIDArrayMIter prototype) {
            if (c.size() == 2) {
                DBIDIter other = c.iter();
                prototype.setDBID((DBIDRef)other);
                return dq.distance((DBIDRef)prototype, (DBIDRef)other.advance());
            }
            double minDistSum = Double.POSITIVE_INFINITY;
            DBIDIter i = c.iter();
            while (i.valid()) {
                double distsum = 0.0;
                DBIDIter j = c.iter();
                while (j.valid() && (DBIDUtil.equal((DBIDRef)i, (DBIDRef)j) || !((distsum += dq.distance((DBIDRef)i, (DBIDRef)j)) >= minDistSum))) {
                    j.advance();
                }
                if (distsum < minDistSum) {
                    minDistSum = distsum;
                    prototype.setDBID((DBIDRef)i);
                }
                i.advance();
            }
            return minDistSum;
        }

        protected void updateMatrix(int x, int y) {
            int j;
            int ybase = ClusterDistanceMatrix.triangleSize(y);
            double[] scratch = this.mat.matrix;
            this.mi.seek(y);
            for (j = 0; j < y; ++j) {
                if (this.mat.clustermap[j] < 0) continue;
                assert (j < y);
                scratch[ybase + j] = this.dq.distance((DBIDRef)this.mi, (DBIDRef)this.mj.seek(j));
            }
            int jbase = ClusterDistanceMatrix.triangleSize(++j);
            while (j < x) {
                if (this.mat.clustermap[j] >= 0) {
                    scratch[jbase + y] = this.dq.distance((DBIDRef)this.mi, (DBIDRef)this.mj.seek(j));
                }
                jbase += j++;
            }
            jbase += j++;
            while (j < this.end) {
                if (this.mat.clustermap[j] >= 0) {
                    scratch[jbase + y] = this.dq.distance((DBIDRef)this.mi, (DBIDRef)this.mj.seek(j));
                }
                jbase += j++;
            }
        }
    }
}

