/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.AGNES;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@References(value={@Reference(authors="S. I. Ao, K. Yip, M. Ng, D. Cheung, P.-Y. Fong, I. Melhado, P. C. Sham", title="CLUSTAG: hierarchical clustering and graph methods for selecting tag SNPs", booktitle="Bioinformatics, 21 (8)", url="https://doi.org/10.1093/bioinformatics/bti201", bibkey="DBLP:journals/bioinformatics/AoYNCFMS05"), @Reference(authors="J. Bien, R. Tibshirani", title="Hierarchical Clustering with Prototypes via Minimax Linkage", booktitle="Journal of the American Statistical Association 106(495)", url="https://doi.org/10.1198/jasa.2011.tm10183", bibkey="doi:10.1198/jasa.2011.tm10183")})
public class MiniMax<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(MiniMax.class);
    protected Distance<? super O> distance;

    public MiniMax(Distance<? super O> distance) {
        this.distance = distance;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public ClusterPrototypeMergeHistory run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).precomputed().distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ArrayModifiableDBIDs prots = DBIDUtil.newArray((int)ClusterDistanceMatrix.triangleSize(ids.size()));
        ClusterDistanceMatrix mat = MiniMax.initializeMatrices(ids, prots, dq);
        return new Instance().run(ids, mat, new ClusterMergeHistoryBuilder(ids, dq.getDistance().isSquared()), dq, prots.iter());
    }

    protected static <O> ClusterDistanceMatrix initializeMatrices(ArrayDBIDs ids, ArrayModifiableDBIDs prots, DistanceQuery<O> dq) {
        ClusterDistanceMatrix mat = new ClusterDistanceMatrix(ids.size());
        DBIDArrayIter ix = ids.iter();
        DBIDArrayIter iy = ids.iter();
        double[] distances = mat.matrix;
        int pos = 0;
        ix.seek(1);
        while (ix.valid()) {
            int x = ix.getOffset();
            assert (pos == ClusterDistanceMatrix.triangleSize(x));
            iy.seek(0);
            while (iy.getOffset() < x) {
                distances[pos++] = dq.distance((DBIDRef)ix, (DBIDRef)iy);
                prots.add((DBIDRef)iy);
                iy.advance();
            }
            ix.advance();
        }
        assert (prots.size() == pos);
        return mat;
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
        }

        public MiniMax<O> make() {
            return new MiniMax<O>(this.distance);
        }
    }

    public static class Instance
    extends AGNES.Instance {
        protected Int2ObjectOpenHashMap<ModifiableDBIDs> clusters;
        protected DBIDArrayMIter protiter;
        protected DistanceQuery<?> dq;
        protected DBIDArrayIter ix;
        protected DBIDArrayIter iy;

        public Instance() {
            super(null);
        }

        @Override
        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            throw new IllegalStateException("Need prototypes.");
        }

        public ClusterPrototypeMergeHistory run(ArrayDBIDs ids, ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder, DistanceQuery<?> dq, DBIDArrayMIter prots) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.clusters = new Int2ObjectOpenHashMap(size);
            this.protiter = prots;
            this.dq = dq;
            this.ix = ids.iter();
            this.iy = ids.iter();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("MiniMax clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
            return (ClusterPrototypeMergeHistory)builder.complete();
        }

        @Override
        protected int findMerge() {
            double[] distances = this.mat.matrix;
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            for (int dx = 0; dx < this.end; ++dx) {
                if (this.mat.clustermap[dx] < 0) continue;
                int xoffset = ClusterDistanceMatrix.triangleSize(dx);
                for (int dy = 0; dy < dx; ++dy) {
                    double dist;
                    if (this.mat.clustermap[dy] < 0 || !((dist = distances[xoffset + dy]) < mindist)) continue;
                    mindist = dist;
                    x = dx;
                    y = dy;
                }
            }
            this.merge(x, y);
            return x;
        }

        protected void merge(int x, int y) {
            assert (x >= 0 && y >= 0);
            assert (y < x);
            double[] distances = this.mat.matrix;
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            if (cy == null) {
                cy = DBIDUtil.newHashSet();
                cy.add((DBIDRef)this.iy.seek(y));
            }
            if (cx == null) {
                cy.add((DBIDRef)this.ix.seek(x));
            } else {
                cy.addDBIDs((DBIDs)cx);
                this.clusters.remove(x);
            }
            this.clusters.put(y, (Object)cy);
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, distances[offset], yy, (DBIDRef)this.protiter.seek(offset));
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.mat.clustermap[x] = -1;
            this.updateMatrices(y);
        }

        protected void updateMatrices(int c) {
            for (int y = 0; y < c; ++y) {
                if (this.mat.clustermap[y] < 0) continue;
                this.updateEntry(c, y);
            }
            for (int x = c + 1; x < this.end; ++x) {
                if (this.mat.clustermap[x] < 0) continue;
                this.updateEntry(x, c);
            }
        }

        protected void updateEntry(int x, int y) {
            double minMaxDist;
            assert (y < x);
            double[] distances = this.mat.matrix;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            DBIDVar prototype = DBIDUtil.newVar((DBIDRef)this.ix.seek(x));
            if (cx != null && cy != null) {
                minMaxDist = Instance.findPrototype(this.dq, (DBIDs)cx, (DBIDs)cy, prototype, Double.POSITIVE_INFINITY);
                minMaxDist = Instance.findPrototype(this.dq, (DBIDs)cy, (DBIDs)cx, prototype, minMaxDist);
            } else if (cx != null) {
                minMaxDist = Instance.findPrototypeSingleton(this.dq, (DBIDs)cx, (DBIDRef)this.iy.seek(y), prototype);
            } else if (cy != null) {
                minMaxDist = Instance.findPrototypeSingleton(this.dq, (DBIDs)cy, (DBIDRef)this.ix.seek(x), prototype);
            } else {
                minMaxDist = this.dq.distance((DBIDRef)this.ix.seek(x), (DBIDRef)this.iy.seek(y));
                prototype.set((DBIDRef)this.ix);
            }
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            distances[offset] = minMaxDist;
            this.protiter.seek(offset).setDBID((DBIDRef)prototype);
        }

        private static double findPrototype(DistanceQuery<?> dq, DBIDs cx, DBIDs cy, DBIDVar prototype, double minMaxDist) {
            DBIDIter i = cx.iter();
            while (i.valid()) {
                double maxDist = Instance.findMax(dq, i, cy, 0.0, minMaxDist);
                if (!(maxDist >= minMaxDist) && (maxDist = Instance.findMax(dq, i, cx, maxDist, minMaxDist)) < minMaxDist) {
                    minMaxDist = maxDist;
                    prototype.set((DBIDRef)i);
                }
                i.advance();
            }
            return minMaxDist;
        }

        private static double findPrototypeSingleton(DistanceQuery<?> dq, DBIDs cx, DBIDRef cy, DBIDVar prototype) {
            double maxDisty = 0.0;
            double minMaxDist = Double.POSITIVE_INFINITY;
            DBIDIter i = cx.iter();
            while (i.valid()) {
                double maxDist = dq.distance((DBIDRef)i, cy);
                double d = maxDisty = maxDist > maxDisty ? maxDist : maxDisty;
                if (!(maxDist >= minMaxDist) && (maxDist = Instance.findMax(dq, i, cx, maxDist, minMaxDist)) < minMaxDist) {
                    minMaxDist = maxDist;
                    prototype.set((DBIDRef)i);
                }
                i.advance();
            }
            if (maxDisty < minMaxDist) {
                minMaxDist = maxDisty;
                prototype.set(cy);
            }
            return minMaxDist;
        }

        private static double findMax(DistanceQuery<?> dq, DBIDIter i, DBIDs cy, double maxDist, double minMaxDist) {
            DBIDIter j = cy.iter();
            while (j.valid()) {
                double dist = dq.distance((DBIDRef)i, (DBIDRef)j);
                if (dist > maxDist) {
                    if (dist >= minMaxDist) {
                        return dist;
                    }
                    maxDist = dist;
                }
                j.advance();
            }
            return maxDist;
        }
    }
}

