/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.Anderberg;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.MiniMax;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@Reference(authors="M. R. Anderberg", title="Hierarchical Clustering Methods", booktitle="Cluster Analysis for Applications", bibkey="books/academic/Anderberg73/Ch6")
@Priority(value=195)
public class MiniMaxAnderberg<O>
extends MiniMax<O> {
    private static final Logging LOG = Logging.getLogger(MiniMaxAnderberg.class);

    public MiniMaxAnderberg(Distance<? super O> distance) {
        super(distance);
    }

    @Override
    public ClusterPrototypeMergeHistory run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).precomputed().distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ArrayModifiableDBIDs prots = DBIDUtil.newArray((int)ClusterDistanceMatrix.triangleSize(ids.size()));
        ClusterDistanceMatrix mat = MiniMax.initializeMatrices(ids, prots, dq);
        return new Instance().run(ids, mat, new ClusterMergeHistoryBuilder(ids, dq.getDistance().isSquared()), dq, prots.iter());
    }

    public static class Par<O>
    extends MiniMax.Par<O> {
        @Override
        public MiniMaxAnderberg<O> make() {
            return new MiniMaxAnderberg(this.distance);
        }
    }

    public static class Instance
    extends MiniMax.Instance {
        protected double[] bestd;
        protected int[] besti;

        @Override
        public ClusterPrototypeMergeHistory run(ArrayDBIDs ids, ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder, DistanceQuery<?> dq, DBIDArrayMIter prots) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.clusters = new Int2ObjectOpenHashMap(size);
            this.protiter = prots;
            this.dq = dq;
            this.ix = ids.iter();
            this.iy = ids.iter();
            this.bestd = new double[size];
            this.besti = new int[size];
            Anderberg.Instance.initializeNNCache(mat.matrix, this.bestd, this.besti);
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Agglomerative clustering", size - 1, LOG) : null;
            for (int i = 1; i < size; ++i) {
                this.end = Instance.shrinkActiveSet(mat.clustermap, this.end, this.findMerge());
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
            return (ClusterPrototypeMergeHistory)builder.complete();
        }

        @Override
        protected int findMerge() {
            double mindist = Double.POSITIVE_INFINITY;
            int x = -1;
            int y = -1;
            for (int cx = 1; cx < this.end; ++cx) {
                double dist;
                int cy = this.besti[cx];
                if (cy < 0 || !((dist = this.bestd[cx]) <= mindist)) continue;
                mindist = dist;
                x = cx;
                y = cy;
            }
            this.merge(x, y);
            return x;
        }

        @Override
        protected void merge(int x, int y) {
            assert (x >= 0 && y >= 0);
            assert (y < x);
            double[] distances = this.mat.matrix;
            int offset = ClusterDistanceMatrix.triangleSize(x) + y;
            ModifiableDBIDs cx = (ModifiableDBIDs)this.clusters.get(x);
            ModifiableDBIDs cy = (ModifiableDBIDs)this.clusters.get(y);
            if (cy == null) {
                cy = DBIDUtil.newHashSet();
                cy.add((DBIDRef)this.iy.seek(y));
            }
            if (cx == null) {
                cy.add((DBIDRef)this.ix.seek(x));
            } else {
                cy.addDBIDs((DBIDs)cx);
                this.clusters.remove(x);
            }
            this.clusters.put(y, (Object)cy);
            int xx = this.mat.clustermap[x];
            int yy = this.mat.clustermap[y];
            int sizex = this.builder.getSize(xx);
            int sizey = this.builder.getSize(yy);
            int zz = this.builder.strictAdd(xx, distances[offset], yy, (DBIDRef)this.protiter.seek(offset));
            assert (this.builder.getSize(zz) == sizex + sizey);
            this.mat.clustermap[y] = zz;
            this.besti[x] = -1;
            this.mat.clustermap[x] = -1;
            this.updateMatrices(x, y);
            if (y > 0) {
                Anderberg.Instance.findBest(distances, this.bestd, this.besti, y);
            }
        }

        private void updateMatrices(int x, int y) {
            int b;
            double[] distances = this.mat.matrix;
            int a = y;
            int yoffset = ClusterDistanceMatrix.triangleSize(y);
            for (b = 0; b < a; ++b) {
                if (this.mat.clustermap[b] < 0) continue;
                this.updateEntry(a, b);
                Anderberg.Instance.updateCache(distances, this.bestd, this.besti, x, y, b, distances[yoffset + b]);
            }
            b = y;
            for (a = y + 1; a < this.end; ++a) {
                if (this.mat.clustermap[a] < 0) continue;
                this.updateEntry(a, b);
                Anderberg.Instance.updateCache(distances, this.bestd, this.besti, x, y, a, distances[ClusterDistanceMatrix.triangleSize(a) + y]);
            }
        }
    }
}

