/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.MiniMax;
import elki.clustering.hierarchical.NNChain;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

@References(value={@Reference(authors="F. Murtagh", title="A survey of recent advances in hierarchical clustering algorithms", booktitle="The Computer Journal 26(4)", url="https://doi.org/10.1093/comjnl/26.4.354", bibkey="DBLP:journals/cj/Murtagh83"), @Reference(authors="D. M\u00fcllner", title="Modern hierarchical, agglomerative clustering algorithms", booktitle="arXiv preprint arXiv:1109.2378", url="https://arxiv.org/abs/1109.2378", bibkey="DBLP:journals/corr/abs-1109-2378")})
public class MiniMaxNNChain<O>
extends MiniMax<O> {
    private static final Logging LOG = Logging.getLogger(MiniMaxNNChain.class);

    public MiniMaxNNChain(Distance<? super O> distance) {
        super(distance);
    }

    @Override
    public ClusterPrototypeMergeHistory run(Relation<O> relation) {
        DistanceQuery dq = new QueryBuilder(relation, this.distance).precomputed().distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ArrayModifiableDBIDs prots = DBIDUtil.newArray((int)ClusterDistanceMatrix.triangleSize(ids.size()));
        ClusterDistanceMatrix mat = MiniMax.initializeMatrices(ids, prots, dq);
        ClusterMergeHistoryBuilder builder = new ClusterMergeHistoryBuilder(ids, this.distance.isSquared());
        return new Instance().run(ids, mat, builder, dq, prots.iter());
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public static class Par<O>
    extends MiniMax.Par<O> {
        @Override
        public MiniMaxNNChain<O> make() {
            return new MiniMaxNNChain(this.distance);
        }
    }

    public static class Instance
    extends MiniMax.Instance {
        @Override
        public ClusterPrototypeMergeHistory run(ArrayDBIDs ids, ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder, DistanceQuery<?> dq, DBIDArrayMIter prots) {
            int size = mat.size;
            this.mat = mat;
            this.builder = builder;
            this.end = size;
            this.clusters = new Int2ObjectOpenHashMap(size);
            this.protiter = prots;
            this.dq = dq;
            this.ix = ids.iter();
            this.iy = ids.iter();
            this.nnChainCore();
            builder.optimizeOrder();
            return (ClusterPrototypeMergeHistory)builder.complete();
        }

        private void nnChainCore() {
            int size = this.mat.size;
            double[] distances = this.mat.matrix;
            int[] clustermap = this.mat.clustermap;
            IntegerArray chain = new IntegerArray(size << 1);
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running MiniMax-NNChain", size - 1, LOG) : null;
            for (int k = 1; k < size; ++k) {
                int a = -1;
                int b = -1;
                if (chain.size() < 2) {
                    a = NNChain.Instance.findUnlinked(0, this.end, clustermap);
                    b = NNChain.Instance.findUnlinked(a + 1, this.end, clustermap);
                    chain.clear();
                    chain.add(a);
                } else {
                    a = chain.get(chain.size - 2);
                    b = chain.get(chain.size - 1);
                    assert (clustermap[a] >= 0 && clustermap[b] >= 0);
                    --chain.size;
                }
                double minDist = this.mat.get(a, b);
                do {
                    double dist;
                    int i;
                    int c = b;
                    int ta = ClusterDistanceMatrix.triangleSize(a);
                    for (i = 0; i < a; ++i) {
                        if (i == b || clustermap[i] < 0 || !((dist = distances[ta + i]) < minDist)) continue;
                        minDist = dist;
                        c = i;
                    }
                    for (i = a + 1; i < this.end; ++i) {
                        if (i == b || clustermap[i] < 0 || !((dist = distances[ClusterDistanceMatrix.triangleSize(i) + a]) < minDist)) continue;
                        minDist = dist;
                        c = i;
                    }
                    b = a;
                    a = c;
                    chain.add(a);
                } while (chain.size() < 3 || a != chain.get(chain.size - 1 - 2));
                if (a < b) {
                    int tmp = a;
                    a = b;
                    b = tmp;
                }
                this.merge(a, b);
                this.end = Instance.shrinkActiveSet(clustermap, this.end, a);
                chain.size -= 3;
                chain.add(b);
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
        }
    }
}

