/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.AGNES;
import elki.clustering.hierarchical.ClusterDistanceMatrix;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.linkage.Linkage;
import elki.clustering.hierarchical.linkage.SingleLinkage;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;

@References(value={@Reference(authors="F. Murtagh", title="A survey of recent advances in hierarchical clustering algorithms", booktitle="The Computer Journal 26(4)", url="https://doi.org/10.1093/comjnl/26.4.354", bibkey="DBLP:journals/cj/Murtagh83"), @Reference(authors="D. M\u00fcllner", title="Modern hierarchical, agglomerative clustering algorithms", booktitle="arXiv preprint arXiv:1109.2378", url="https://arxiv.org/abs/1109.2378", bibkey="DBLP:journals/corr/abs-1109-2378")})
public class NNChain<O>
extends AGNES<O> {
    private static final Logging LOG = Logging.getLogger(NNChain.class);

    public NNChain(Distance<? super O> distance, Linkage linkage) {
        super(distance, linkage);
    }

    @Override
    public ClusterMergeHistory run(Relation<O> relation) {
        if (SingleLinkage.class.isInstance(this.linkage)) {
            LOG.verbose((CharSequence)"Notice: SLINK is a much faster algorithm for single-linkage clustering!");
        }
        DistanceQuery dq = new QueryBuilder(relation, this.distance).distanceQuery();
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        ClusterDistanceMatrix mat = NNChain.initializeDistanceMatrix(ids, dq, this.linkage);
        return new Instance(this.linkage).run(mat, new ClusterMergeHistoryBuilder(ids, this.distance.isSquared()));
    }

    public static class Par<O>
    extends AGNES.Par<O> {
        @Override
        public NNChain<O> make() {
            return new NNChain(this.distance, this.linkage);
        }
    }

    public static class Instance
    extends AGNES.Instance {
        public Instance(Linkage linkage) {
            super(linkage);
        }

        @Override
        public ClusterMergeHistory run(ClusterDistanceMatrix mat, ClusterMergeHistoryBuilder builder) {
            this.mat = mat;
            this.builder = builder;
            this.end = mat.size;
            this.nnChainCore();
            builder.optimizeOrder();
            return builder.complete();
        }

        private void nnChainCore() {
            int size = this.mat.size;
            boolean warnedIrreducible = false;
            double[] distances = this.mat.matrix;
            int[] clustermap = this.mat.clustermap;
            IntegerArray chain = new IntegerArray(size >> 2);
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running NNChain", size - 1, LOG) : null;
            for (int k = 1; k < size; ++k) {
                int a = -1;
                int b = -1;
                if (chain.size() < 2) {
                    a = Instance.findUnlinked(0, this.end, clustermap);
                    b = Instance.findUnlinked(a + 1, this.end, clustermap);
                    assert (clustermap[a] >= 0 && clustermap[b] >= 0);
                    chain.clear();
                    chain.add(a);
                } else {
                    a = chain.get(chain.size - 2);
                    b = chain.get(chain.size - 1);
                    assert (clustermap[b] >= 0);
                    if (clustermap[a] < 0) {
                        if (!warnedIrreducible) {
                            LOG.warning((CharSequence)"Detected an inversion in the clustering. NNChain on irreducible linkages may yield different results.");
                            warnedIrreducible = true;
                        }
                        chain.size -= 2;
                        --k;
                        continue;
                    }
                    --chain.size;
                }
                double minDist = this.mat.get(a, b);
                do {
                    double dist;
                    int i;
                    int c = b;
                    int ta = ClusterDistanceMatrix.triangleSize(a);
                    for (i = 0; i < a; ++i) {
                        if (i == b || clustermap[i] < 0 || !((dist = distances[ta + i]) < minDist)) continue;
                        minDist = dist;
                        c = i;
                    }
                    for (i = a + 1; i < this.end; ++i) {
                        if (i == b || clustermap[i] < 0 || !((dist = distances[ClusterDistanceMatrix.triangleSize(i) + a]) < minDist)) continue;
                        minDist = dist;
                        c = i;
                    }
                    b = a;
                    a = c;
                    chain.add(a);
                } while (chain.size() < 3 || a != chain.get(chain.size - 1 - 2));
                if (a < b) {
                    int tmp = a;
                    a = b;
                    b = tmp;
                }
                assert (minDist == this.mat.get(a, b));
                this.merge(minDist, a, b);
                chain.size -= 3;
                chain.add(b);
                this.end = Instance.shrinkActiveSet(clustermap, this.end, a);
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
        }

        public static int findUnlinked(int pos, int end, int[] clustermap) {
            while (pos < end) {
                if (clustermap[pos] >= 0) {
                    return pos;
                }
                ++pos;
            }
            return -1;
        }
    }
}

