/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.optics.ClusterOrder;
import elki.clustering.optics.OPTICSHeap;
import elki.clustering.optics.OPTICSTypeAlgorithm;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDRef;
import elki.math.MathUtil;
import elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="J\u00f6rg Sander, Xuejie Qin, Zhiyong Lu, Nan Niu, Alex Kovarsky", title="Automatic Extraction of Clusters from Hierarchical Clustering Representations", booktitle="7th Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining, PAKDD", url="https://doi.org/10.1007/3-540-36175-8_8", bibkey="DBLP:conf/pakdd/SanderQLNK03")
public class OPTICSToHierarchical
implements HierarchicalClusteringAlgorithm {
    OPTICSTypeAlgorithm inner;

    public OPTICSToHierarchical(OPTICSTypeAlgorithm inner) {
        this.inner = inner;
    }

    @Override
    public ClusterMergeHistory autorun(Database database) {
        ClusterOrder in = this.inner.autorun(database);
        ArrayDBIDs ids = in.getDBIDs();
        int[] ord = MathUtil.sequence((int)1, (int)ids.size());
        double[] d = new double[ord.length];
        DBIDArrayIter it = ids.iter().seek(1);
        while (it.valid()) {
            d[it.getOffset() - 1] = in.getReachability((DBIDRef)it);
            it.advance();
        }
        DoubleIntegerArrayQuickSort.sort((double[])d, (int[])ord, (int)d.length);
        ClusterMergeHistoryBuilder builder = new ClusterMergeHistoryBuilder(ids, false);
        for (int i = 0; i < ord.length; ++i) {
            builder.add(ord[i] - 1, d[i], ord[i]);
        }
        return builder.complete();
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.inner.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID OPTICS_ID = new OptionID("optics", "OPTICS algorithm to use.");
        OPTICSTypeAlgorithm inner;

        public void configure(Parameterization config) {
            new ObjectParameter(OPTICS_ID, OPTICSTypeAlgorithm.class, OPTICSHeap.class).grab(config, x -> {
                this.inner = x;
            });
        }

        public OPTICSToHierarchical make() {
            return new OPTICSToHierarchical(this.inner);
        }
    }
}

