/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.Algorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DBIDDataStore;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDRange;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.PrimitiveDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Description;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Comparator;

@Title(value="SLINK: Single Link Clustering")
@Description(value="Hierarchical clustering algorithm based on single-link connectivity.")
@Reference(authors="R. Sibson", title="SLINK: An optimally efficient algorithm for the single-link cluster method", booktitle="The Computer Journal 16 (1)", url="https://doi.org/10.1093/comjnl/16.1.30", bibkey="DBLP:journals/cj/Sibson73")
@Alias(value={"single-link", "single-linkage"})
@Priority(value=200)
public class SLINK<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINK.class);
    protected Distance<? super O> distance;

    public SLINK(Distance<? super O> distance) {
        this.distance = distance;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public ClusterMergeHistory run(Relation<O> relation) {
        Logging log = this.getLogger();
        DBIDs ids = relation.getDBIDs();
        WritableDBIDDataStore pi = DataStoreUtil.makeDBIDStorage((DBIDs)ids, (int)6);
        WritableDoubleDataStore lambda = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)6, (double)Double.POSITIVE_INFINITY);
        WritableDoubleDataStore m = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Running SLINK", ids.size(), log) : null;
        ArrayDBIDs aids = DBIDUtil.ensureArray((DBIDs)ids);
        DBIDArrayIter id = aids.iter();
        DBIDArrayIter it = aids.iter();
        while (id.valid()) {
            pi.put((DBIDRef)id, (DBIDRef)id);
            id.advance();
        }
        log.incrementProcessed((AbstractProgress)progress);
        if (this.distance instanceof PrimitiveDistance) {
            PrimitiveDistance distf = (PrimitiveDistance)this.distance;
            id.seek(1);
            while (id.valid()) {
                this.step2primitive((DBIDRef)id, it, id.getOffset(), relation, distf, m);
                this.process((DBIDRef)id, aids, it, id.getOffset(), pi, lambda, m);
                log.incrementProcessed((AbstractProgress)progress);
                id.advance();
            }
        } else {
            DistanceQuery distQ = new QueryBuilder(relation, this.distance).distanceQuery();
            id.seek(1);
            while (id.valid()) {
                this.step2((DBIDRef)id, it, id.getOffset(), distQ, m);
                this.process((DBIDRef)id, aids, it, id.getOffset(), pi, lambda, m);
                log.incrementProcessed((AbstractProgress)progress);
                id.advance();
            }
        }
        log.ensureCompleted(progress);
        m.destroy();
        return SLINK.convertOutput(new ClusterMergeHistoryBuilder(aids, this.distance.isSquared()), aids, (DBIDDataStore)pi, (DoubleDataStore)lambda).complete();
    }

    protected static ClusterMergeHistoryBuilder convertOutput(ClusterMergeHistoryBuilder builder, ArrayDBIDs oids, DBIDDataStore pi, DoubleDataStore lambda) {
        ArrayModifiableDBIDs ids = DBIDUtil.newArray((DBIDs)oids);
        ids.sort((Comparator)new DataStoreUtil.AscendingByDoubleDataStoreAndId(lambda));
        DBIDVar p = DBIDUtil.newVar();
        if (oids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)oids;
            DBIDArrayMIter it = ids.iter();
            while (it.valid()) {
                double d = lambda.doubleValue((DBIDRef)it);
                if (!DBIDUtil.equal((DBIDRef)it, (DBIDRef)pi.assignVar((DBIDRef)it, p))) {
                    builder.add(range.getOffset((DBIDRef)it), d, range.getOffset((DBIDRef)p));
                }
                it.advance();
            }
        } else {
            WritableIntegerDataStore idx = DataStoreFactory.FACTORY.makeIntegerStorage((DBIDs)oids, 3);
            DBIDArrayIter it = oids.iter();
            while (it.valid()) {
                idx.putInt((DBIDRef)it, it.getOffset());
                it.advance();
            }
            it = ids.iter();
            while (it.valid()) {
                double d = lambda.doubleValue((DBIDRef)it);
                if (!DBIDUtil.equal((DBIDRef)it, (DBIDRef)pi.assignVar((DBIDRef)it, p))) {
                    builder.add(idx.intValue((DBIDRef)it), d, idx.intValue((DBIDRef)p));
                }
                it.advance();
            }
            idx.destroy();
        }
        return builder;
    }

    private void step2(DBIDRef id, DBIDArrayIter it, int n, DistanceQuery<? super O> distQuery, WritableDoubleDataStore m) {
        it.seek(0);
        while (it.getOffset() < n) {
            m.putDouble((DBIDRef)it, distQuery.distance((DBIDRef)it, id));
            it.advance();
        }
    }

    private void step2primitive(DBIDRef id, DBIDArrayIter it, int n, Relation<? extends O> relation, PrimitiveDistance<? super O> distance, WritableDoubleDataStore m) {
        Object newObj = relation.get(id);
        it.seek(0);
        while (it.getOffset() < n) {
            m.putDouble((DBIDRef)it, distance.distance(relation.get((DBIDRef)it), newObj));
            it.advance();
        }
    }

    protected void process(DBIDRef id, ArrayDBIDs ids, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        this.slinkstep3(id, it, n, pi, lambda, m);
        this.slinkstep4(id, it, n, pi, lambda);
    }

    private void slinkstep3(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            double l_i = lambda.doubleValue((DBIDRef)it);
            double m_i = m.doubleValue((DBIDRef)it);
            p_i.from((DBIDDataStore)pi, (DBIDRef)it);
            double mp_i = m.doubleValue((DBIDRef)p_i);
            if (l_i >= m_i) {
                if (l_i < mp_i) {
                    m.putDouble((DBIDRef)p_i, l_i);
                }
                lambda.putDouble((DBIDRef)it, m_i);
                pi.put((DBIDRef)it, id);
            } else if (m_i < mp_i) {
                m.putDouble((DBIDRef)p_i, m_i);
            }
            it.advance();
        }
    }

    private void slinkstep4(DBIDRef id, DBIDArrayIter it, int n, WritableDBIDDataStore pi, WritableDoubleDataStore lambda) {
        DBIDVar p_i = DBIDUtil.newVar();
        it.seek(0);
        while (it.getOffset() < n) {
            double l_i = lambda.doubleValue((DBIDRef)it);
            p_i.from((DBIDDataStore)pi, (DBIDRef)it);
            double lp_i = lambda.doubleValue((DBIDRef)p_i);
            if (l_i >= lp_i) {
                pi.put((DBIDRef)it, id);
            }
            it.advance();
        }
    }

    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    implements Parameterizer {
        protected Distance<? super O> distance;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
        }

        public SLINK<O> make() {
            return new SLINK<O>(this.distance);
        }
    }
}

