/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical;

import elki.clustering.hierarchical.AbstractHDBSCAN;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistoryBuilder;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.SLINK;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.datastore.DBIDDataStore;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDBIDDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.ArrayDBIDs;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.QueryBuilder;
import elki.database.query.distance.DistanceQuery;
import elki.database.query.knn.KNNSearcher;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.math.MathUtil;
import elki.utilities.documentation.Reference;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
public class SLINKHDBSCANLinearMemory<O>
extends AbstractHDBSCAN<O>
implements HierarchicalClusteringAlgorithm {
    private static final Logging LOG = Logging.getLogger(SLINKHDBSCANLinearMemory.class);

    public SLINKHDBSCANLinearMemory(Distance<? super O> distance, int minPts) {
        super(distance, minPts);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{this.distance.getInputTypeRestriction()});
    }

    public ClusterMergeHistory run(Relation<O> relation) {
        QueryBuilder qb = new QueryBuilder(relation, this.distance);
        DistanceQuery distQ = qb.distanceQuery();
        KNNSearcher knnQ = qb.kNNByDBID(this.minPts);
        ArrayDBIDs ids = DBIDUtil.ensureArray((DBIDs)relation.getDBIDs());
        WritableDoubleDataStore coredists = this.computeCoreDists((DBIDs)ids, (KNNSearcher<DBIDRef>)knnQ, this.minPts);
        WritableDBIDDataStore pi = DataStoreUtil.makeDBIDStorage((DBIDs)ids, (int)6);
        WritableDoubleDataStore lambda = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)6, (double)Double.POSITIVE_INFINITY);
        WritableDoubleDataStore m = DataStoreUtil.makeDoubleStorage((DBIDs)ids, (int)3);
        FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Running HDBSCAN*-SLINK", ids.size(), LOG) : null;
        ArrayModifiableDBIDs processedIDs = DBIDUtil.newArray((int)ids.size());
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            pi.put((DBIDRef)id, (DBIDRef)id);
            this.step2((DBIDRef)id, (DBIDs)processedIDs, distQ, (DoubleDataStore)coredists, m);
            this.step3((DBIDRef)id, pi, lambda, (DBIDs)processedIDs, m);
            this.step4((DBIDRef)id, pi, lambda, (DBIDs)processedIDs);
            processedIDs.add((DBIDRef)id);
            LOG.incrementProcessed((AbstractProgress)progress);
            id.advance();
        }
        LOG.ensureCompleted(progress);
        return SLINK.convertOutput(new ClusterMergeHistoryBuilder(ids, this.distance.isSquared()), ids, (DBIDDataStore)pi, (DoubleDataStore)lambda).complete(coredists);
    }

    private void step2(DBIDRef id, DBIDs processedIDs, DistanceQuery<? super O> distQuery, DoubleDataStore coredists, WritableDoubleDataStore m) {
        double coreP = coredists.doubleValue(id);
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            m.putDouble((DBIDRef)it, MathUtil.max((double)coreP, (double)coredists.doubleValue((DBIDRef)it), (double)distQuery.distance(id, (DBIDRef)it)));
            it.advance();
        }
    }

    private void step3(DBIDRef id, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, DBIDs processedIDs, WritableDoubleDataStore m) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            double l_i = lambda.doubleValue((DBIDRef)it);
            double m_i = m.doubleValue((DBIDRef)it);
            pi.assignVar((DBIDRef)it, p_i);
            double mp_i = m.doubleValue((DBIDRef)p_i);
            if (l_i >= m_i) {
                if (l_i < mp_i) {
                    m.putDouble((DBIDRef)p_i, l_i);
                }
                lambda.putDouble((DBIDRef)it, m_i);
                pi.put((DBIDRef)it, id);
            } else if (m_i < mp_i) {
                m.putDouble((DBIDRef)p_i, m_i);
            }
            it.advance();
        }
    }

    private void step4(DBIDRef id, WritableDBIDDataStore pi, WritableDoubleDataStore lambda, DBIDs processedIDs) {
        DBIDVar p_i = DBIDUtil.newVar();
        DBIDIter it = processedIDs.iter();
        while (it.valid()) {
            double l_i = lambda.doubleValue((DBIDRef)it);
            pi.assignVar((DBIDRef)it, p_i);
            double lp_i = lambda.doubleValue((DBIDRef)p_i);
            if (l_i >= lp_i) {
                pi.put((DBIDRef)it, id);
            }
            it.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<O>
    extends AbstractHDBSCAN.Par<O> {
        public SLINKHDBSCANLinearMemory<O> make() {
            return new SLINKHDBSCANLinearMemory(this.distance, this.minPts);
        }
    }
}

