/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.hierarchical.birch.BIRCHDistance;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.NumberVector;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"D3"})
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class AverageIntraclusterDistance
implements BIRCHDistance {
    public static final AverageIntraclusterDistance STATIC = new AverageIntraclusterDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusteringFeature cf) {
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        double div1 = 1.0 / (double)(1 + cf.n);
        double div2 = 1.0 / (double)cf.n;
        double sum = (cf.sumOfSumOfSquares() + ClusteringFeature.sumOfSquares(v)) * div2;
        for (int d = 0; d < dim; ++d) {
            double x = cf.ls[d] + v.doubleValue(d);
            sum -= x * div1 * (x * div2);
        }
        return sum > 0.0 ? sum * 2.0 : 0.0;
    }

    @Override
    public double squaredDistance(ClusteringFeature cf1, ClusteringFeature cf2) {
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        int n12 = cf1.n + cf2.n;
        double div1 = 1.0 / (double)n12;
        double div2 = 1.0 / (double)(n12 - 1);
        double sum = (cf1.sumOfSumOfSquares() + cf2.sumOfSumOfSquares()) * div2;
        for (int d = 0; d < dim; ++d) {
            double x = cf1.ls[d] + cf2.ls[d];
            sum -= x * div1 * (x * div2);
        }
        return sum > 0.0 ? sum * 2.0 : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public AverageIntraclusterDistance make() {
            return STATIC;
        }
    }
}

