/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.kmeans.KMeans;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;
import java.util.Random;

public class BIRCHKMeansPlusPlus {
    protected RandomFactory random;
    protected double[] weights;

    public BIRCHKMeansPlusPlus(RandomFactory rnd) {
        this.random = rnd;
    }

    public double[][] run(double[][] x, int k) {
        Random rnd = this.random.getSingleThreadedRandom();
        double[][] means = new double[k][];
        int first = rnd.nextInt(x.length);
        means[0] = (double[])x[first].clone();
        double weightsum = this.initialWeights(means[0], x);
        for (int m = 1; m < k; ++m) {
            int i;
            if (weightsum > Double.MAX_VALUE) {
                throw new IllegalStateException("Could not choose a reasonable mean - too many data points, too large distance sum?");
            }
            double r = rnd.nextDouble() * weightsum;
            for (i = 0; i < x.length; ++i) {
                double d;
                r -= this.weights[i];
                if (d <= 0.0) break;
            }
            if (i >= x.length) {
                weightsum -= r;
                continue;
            }
            means[m] = (double[])x[i].clone();
            if (m >= k - 1) continue;
            this.weights[i] = 0.0;
            weightsum = this.updateWeights(means[m], x);
        }
        return means;
    }

    private double initialWeights(double[] first, double[][] x) {
        double weightsum = 0.0;
        this.weights = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.weights[i] = this.distance(first, x[i]);
            weightsum += this.weights[i];
        }
        return weightsum;
    }

    private double distance(double[] ds, double[] ds2) {
        double v = 0.0;
        for (int i = 0; i < ds.length; ++i) {
            double d = ds[i] - ds2[i];
            v += d * d;
        }
        return v;
    }

    private double updateWeights(double[] latest, double[][] x) {
        double weightsum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double weight = this.weights[i];
            if (weight <= 0.0) continue;
            double newweight = this.distance(latest, x[i]);
            weightsum += newweight < weight ? newweight : weight;
        }
        return weightsum;
    }

    public static class Par
    implements Parameterizer {
        protected RandomFactory rnd;

        public void configure(Parameterization config) {
            new RandomParameter(KMeans.SEED_ID).grab(config, x -> {
                this.rnd = x;
            });
        }

        public BIRCHKMeansPlusPlus make() {
            return new BIRCHKMeansPlusPlus(this.rnd);
        }
    }
}

