/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.birch.CFTree;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.data.type.TypeInformation;
import elki.data.type.TypeUtil;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.database.relation.RelationUtil;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import java.util.HashMap;
import java.util.Map;

@References(value={@Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: An Efficient Data Clustering Method for Very Large Databases", booktitle="Proc. 1996 ACM SIGMOD International Conference on Management of Data", url="https://doi.org/10.1145/233269.233324", bibkey="DBLP:conf/sigmod/ZhangRL96"), @Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: A New Data Clustering Algorithm and Its Applications", booktitle="Data Min. Knowl. Discovery", url="https://doi.org/10.1023/A:1009783824328", bibkey="DBLP:journals/datamine/ZhangRL97")})
public class BIRCHLeafClustering
implements ClusteringAlgorithm<Clustering<MeanModel>> {
    CFTree.Factory cffactory;

    public BIRCHLeafClustering(CFTree.Factory cffactory) {
        this.cffactory = cffactory;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array((TypeInformation[])new TypeInformation[]{TypeUtil.NUMBER_VECTOR_FIELD});
    }

    public Clustering<MeanModel> run(Relation<NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        CFTree tree = this.cffactory.newTree(relation.getDBIDs(), relation);
        HashMap<ClusteringFeature, ModifiableDBIDs> idmap = new HashMap<ClusteringFeature, ModifiableDBIDs>(tree.leaves);
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            idmap.computeIfAbsent(tree.findLeaf((NumberVector)relation.get((DBIDRef)iter)), x -> DBIDUtil.newArray((int)x.n)).add((DBIDRef)iter);
            iter.advance();
        }
        Clustering<MeanModel> result = new Clustering<MeanModel>();
        for (Map.Entry ent : idmap.entrySet()) {
            ClusteringFeature leaf = (ClusteringFeature)ent.getKey();
            double[] center = new double[dim];
            for (int i = 0; i < dim; ++i) {
                center[i] = leaf.centroid(i);
            }
            result.addToplevelCluster(new Cluster<MeanModel>((DBIDs)ent.getValue(), new MeanModel(center)));
        }
        Metadata.of(result).setLongName("BIRCH Clustering");
        return result;
    }

    public static class Par
    implements Parameterizer {
        CFTree.Factory cffactory;

        public void configure(Parameterization config) {
            this.cffactory = (CFTree.Factory)config.tryInstantiate(CFTree.Factory.class);
        }

        public BIRCHLeafClustering make() {
            return new BIRCHLeafClustering(this.cffactory);
        }
    }
}

