/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.hierarchical.birch.BIRCHDistance;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.NumberVector;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"D0"})
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class CentroidEuclideanDistance
implements BIRCHDistance {
    public static final CentroidEuclideanDistance STATIC = new CentroidEuclideanDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusteringFeature cf) {
        int d = v.getDimensionality();
        assert (d == cf.getDimensionality());
        double sum = 0.0;
        for (int i = 0; i < d; ++i) {
            double dx = cf.centroid(i) - v.doubleValue(i);
            sum += dx * dx;
        }
        return sum;
    }

    @Override
    public double squaredDistance(ClusteringFeature v, ClusteringFeature cf) {
        int d = v.getDimensionality();
        assert (d == cf.getDimensionality());
        double sum = 0.0;
        for (int i = 0; i < d; ++i) {
            double dx = cf.centroid(i) - v.centroid(i);
            sum += dx * dx;
        }
        return sum;
    }

    public static class Par
    implements Parameterizer {
        public CentroidEuclideanDistance make() {
            return STATIC;
        }
    }
}

