/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.data.NumberVector;
import elki.math.linearalgebra.VMath;
import java.util.Arrays;

public class ClusteringFeature {
    int n = 0;
    double[] ls;
    double ss;

    public ClusteringFeature(int dimensionality) {
        this.ls = new double[dimensionality];
    }

    protected void addToStatistics(NumberVector nv) {
        int d = nv.getDimensionality();
        assert (d == this.ls.length);
        ++this.n;
        int i = 0;
        while (i < d) {
            double v = nv.doubleValue(i);
            int n = i++;
            this.ls[n] = this.ls[n] + v;
            this.ss += v * v;
        }
    }

    protected void addToStatistics(ClusteringFeature other) {
        this.n += other.n;
        VMath.plusEquals((double[])this.ls, (double[])other.ls);
        this.ss += other.ss;
    }

    protected void resetStatistics() {
        this.n = 0;
        Arrays.fill(this.ls, 0.0);
        this.ss = 0.0;
    }

    public double centroid(int i) {
        return this.n > 0 ? this.ls[i] / (double)this.n : 0.0;
    }

    public double sumOfSumOfSquares() {
        return this.ss;
    }

    public double sumOfSquaresOfSums() {
        double sum = 0.0;
        for (int i = 0; i < this.ls.length; ++i) {
            double v = this.ls[i];
            sum += v * v;
        }
        return sum;
    }

    public int getDimensionality() {
        return this.ls.length;
    }

    public static double sumOfSquares(NumberVector v) {
        int dim = v.getDimensionality();
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x = v.doubleValue(d);
            sum += x * x;
        }
        return sum;
    }
}

