/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.hierarchical.birch.BIRCHAbsorptionCriterion;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.NumberVector;
import elki.utilities.optionhandling.Parameterizer;

public class EuclideanDistanceCriterion
implements BIRCHAbsorptionCriterion {
    public static final EuclideanDistanceCriterion STATIC = new EuclideanDistanceCriterion();

    @Override
    public double squaredCriterion(ClusteringFeature f1, NumberVector n) {
        assert (f1.n > 0);
        int dim = f1.ls.length;
        double div = 1.0 / (double)f1.n;
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double v = f1.ls[d] * div - n.doubleValue(d);
            sum += v * v;
        }
        return sum;
    }

    @Override
    public double squaredCriterion(ClusteringFeature f1, ClusteringFeature f2) {
        assert (f1.n > 0 && f2.n > 0);
        int dim = f1.ls.length;
        double div1 = 1.0 / (double)f1.n;
        double div2 = 1.0 / (double)f2.n;
        double sum = 0.0;
        for (int d = 0; d < dim; ++d) {
            double v = f1.ls[d] * div1 - f2.ls[d] * div2;
            sum += v * v;
        }
        return sum;
    }

    public static class Par
    implements Parameterizer {
        public EuclideanDistanceCriterion make() {
            return STATIC;
        }
    }
}

