/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.hierarchical.birch.BIRCHAbsorptionCriterion;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.NumberVector;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"R"})
@Reference(authors="T. Zhang, R. Ramakrishnan, M. Livny", title="BIRCH: An Efficient Data Clustering Method for Very Large Databases", booktitle="Proc. 1996 ACM SIGMOD International Conference on Management of Data", url="https://doi.org/10.1145/233269.233324", bibkey="DBLP:conf/sigmod/ZhangRL96")
public class RadiusCriterion
implements BIRCHAbsorptionCriterion {
    public static final RadiusCriterion STATIC = new RadiusCriterion();

    @Override
    public double squaredCriterion(ClusteringFeature f1, NumberVector n) {
        double v;
        int d;
        if (f1.n <= 0) {
            return 0.0;
        }
        int dim = f1.ls.length;
        double div = 1.0 / (double)(f1.n + 1);
        double sum = f1.sumOfSumOfSquares();
        for (d = 0; d < dim; ++d) {
            v = n.doubleValue(d);
            sum += v * v;
        }
        sum *= div;
        for (d = 0; d < dim; ++d) {
            v = (f1.ls[d] + n.doubleValue(d)) * div;
            sum -= v * v;
        }
        return sum;
    }

    @Override
    public double squaredCriterion(ClusteringFeature f1, ClusteringFeature f2) {
        int n12 = f1.n + f2.n;
        if (n12 <= 1) {
            return 0.0;
        }
        int dim = f1.ls.length;
        double div = 1.0 / (double)n12;
        double sum = (f1.sumOfSumOfSquares() + f2.sumOfSumOfSquares()) * div;
        for (int i = 0; i < dim; ++i) {
            double v = (f1.ls[i] + f2.ls[i]) * div;
            sum -= v * v;
        }
        return sum;
    }

    public static class Par
    implements Parameterizer {
        public RadiusCriterion make() {
            return STATIC;
        }
    }
}

