/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.birch;

import elki.clustering.hierarchical.birch.BIRCHDistance;
import elki.clustering.hierarchical.birch.ClusteringFeature;
import elki.data.NumberVector;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Alias(value={"D4"})
@Reference(authors="T. Zhang", title="Data Clustering for Very Large Datasets Plus Applications", booktitle="University of Wisconsin Madison, Technical Report #1355", url="ftp://ftp.cs.wisc.edu/pub/techreports/1997/TR1355.pdf", bibkey="tr/wisc/Zhang97")
public class VarianceIncreaseDistance
implements BIRCHDistance {
    public static final VarianceIncreaseDistance STATIC = new VarianceIncreaseDistance();

    @Override
    public double squaredDistance(NumberVector v, ClusteringFeature cf) {
        int dim = v.getDimensionality();
        assert (dim == cf.getDimensionality());
        int n2 = cf.n;
        int n3 = 1 + n2;
        double div2 = 1.0 / (double)n2;
        double div3 = 1.0 / (double)n3;
        double dot1 = 0.0;
        double dot2 = 0.0;
        double dot3 = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x1 = v.doubleValue(d);
            double x2 = cf.ls[d];
            double x3 = (x1 + x2) * div3;
            dot1 += x1 * x1;
            dot2 += (x2 *= div2) * x2;
            dot3 += x3 * x3;
        }
        double sum = dot1 + (double)n2 * dot2 - (double)n3 * dot3;
        return sum > 0.0 ? sum : 0.0;
    }

    @Override
    public double squaredDistance(ClusteringFeature cf1, ClusteringFeature cf2) {
        int dim = cf1.getDimensionality();
        assert (dim == cf2.getDimensionality());
        int n1 = cf1.n;
        int n2 = cf2.n;
        int n3 = n1 + n2;
        double div1 = 1.0 / (double)n1;
        double div2 = 1.0 / (double)n2;
        double div3 = 1.0 / (double)n3;
        double dot1 = 0.0;
        double dot2 = 0.0;
        double dot3 = 0.0;
        for (int d = 0; d < dim; ++d) {
            double x1 = cf1.ls[d];
            double x2 = cf2.ls[d];
            double x3 = (x1 + x2) * div3;
            dot1 += (x1 *= div1) * x1;
            dot2 += (x2 *= div2) * x2;
            dot3 += x3 * x3;
        }
        double sum = (double)n1 * dot1 + (double)n2 * dot2 - (double)n3 * dot3;
        return sum > 0.0 ? sum : 0.0;
    }

    public static class Par
    implements Parameterizer {
        public VarianceIncreaseDistance make() {
            return STATIC;
        }
    }
}

