/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.extraction;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.data.model.PrototypeDendrogramModel;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.datastructures.arraylike.IntegerArray;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;

public abstract class AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    protected final boolean hierarchical;
    protected final HierarchicalClusteringAlgorithm algorithm;
    protected final boolean simplify;

    public AbstractCutDendrogram(HierarchicalClusteringAlgorithm algorithm, boolean hierarchical, boolean simplify) {
        this.algorithm = algorithm;
        this.hierarchical = hierarchical;
        this.simplify = simplify;
    }

    public Clustering<DendrogramModel> run(Database database) {
        assert (this.algorithm != null) : "To auto-run on a database, the algorithm must be configured.";
        return this.run(this.algorithm.autorun(database));
    }

    public abstract Clustering<DendrogramModel> run(ClusterMergeHistory var1);

    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    protected abstract Logging getLogger();

    public static abstract class Par
    implements Parameterizer {
        public static final OptionID HIERARCHICAL_ID = new OptionID("hierarchical.hierarchy", "Generate a truncated hierarchical clustering result (or strict partitions).");
        public static final OptionID NOSIMPLIFY_ID = new OptionID("hierarchical.nosimplify", "Do not put single points directly into merge clusters.");
        boolean hierarchical = false;
        HierarchicalClusteringAlgorithm algorithm;
        boolean simplify;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class).grab(config, x -> {
                this.algorithm = x;
            });
            new Flag(HIERARCHICAL_ID).grab(config, x -> {
                this.hierarchical = x;
            });
            if (this.hierarchical) {
                new Flag(NOSIMPLIFY_ID).grab(config, x -> {
                    this.simplify = !x;
                });
            }
        }
    }

    public abstract class Instance {
        protected ClusterMergeHistory merges;
        protected Int2IntOpenHashMap leafMap;
        protected IntegerArray leafTop;
        protected ArrayList<ModifiableDBIDs> clusterMembers;

        public Instance(ClusterMergeHistory merges) {
            this.merges = merges;
        }

        public Clustering<DendrogramModel> extractClusters() {
            Logging log = AbstractCutDendrogram.this.getLogger();
            int split = this.findSplit();
            FiniteProgress progress = log.isVerbose() ? new FiniteProgress("Extracting clusters", this.merges.numMerges(), log) : null;
            int expcnum = this.merges.size() - split + 1;
            this.leafMap = new Int2IntOpenHashMap(this.merges.size());
            this.leafMap.defaultReturnValue(-1);
            this.clusterMembers = new ArrayList(expcnum);
            this.leafTop = new IntegerArray(expcnum);
            this.buildLeafClusters(split, progress);
            Clustering<DendrogramModel> dendrogram = AbstractCutDendrogram.this.hierarchical ? this.buildHierarchical(split, progress) : this.buildFlat(split, progress);
            log.ensureCompleted(progress);
            return dendrogram;
        }

        private void buildLeafClusters(int split, FiniteProgress progress) {
            Logging log = AbstractCutDendrogram.this.getLogger();
            DBIDVar tmp = DBIDUtil.newVar();
            int n = this.merges.size();
            for (int i = split - 1; i >= 0; --i) {
                int a = this.merges.getMergeA(i);
                int b = this.merges.getMergeB(i);
                int c = this.leafMap.remove(i + n);
                ArrayModifiableDBIDs ci = null;
                if (c < 0) {
                    c = this.clusterMembers.size();
                    ci = DBIDUtil.newArray();
                    this.clusterMembers.add((ModifiableDBIDs)ci);
                    this.leafTop.add(i);
                } else {
                    ci = this.clusterMembers.get(c);
                }
                if (b < n) {
                    ci.add((DBIDRef)this.merges.assignVar(b, tmp));
                } else {
                    this.leafMap.put(b, c);
                }
                if (a < n) {
                    ci.add((DBIDRef)this.merges.assignVar(a, tmp));
                } else {
                    this.leafMap.put(a, c);
                }
                log.incrementProcessed((AbstractProgress)progress);
            }
        }

        private Clustering<DendrogramModel> buildFlat(int split, FiniteProgress progress) {
            Logging log = AbstractCutDendrogram.this.getLogger();
            int n = this.merges.size();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>();
            Metadata.of(dendrogram).setLongName("Flattened Hierarchical Clustering");
            for (int i = 0; i < this.leafTop.size; ++i) {
                dendrogram.addToplevelCluster(this.makeCluster(this.leafTop.get(i) + n, (DBIDs)this.clusterMembers.get(i)));
            }
            DBIDVar tmp = DBIDUtil.newVar();
            int m = this.merges.numMerges();
            for (int i = split; i < m; ++i) {
                int a = this.merges.getMergeA(i);
                int b = this.merges.getMergeB(i);
                if (a < m) {
                    dendrogram.addToplevelCluster(this.makeCluster(a, (DBIDs)DBIDUtil.deref((DBIDRef)this.merges.assignVar(a, tmp))));
                }
                if (b < m) {
                    dendrogram.addToplevelCluster(this.makeCluster(b, (DBIDs)DBIDUtil.deref((DBIDRef)this.merges.assignVar(b, tmp))));
                }
                log.incrementProcessed((AbstractProgress)progress);
            }
            return dendrogram;
        }

        private Clustering<DendrogramModel> buildHierarchical(int split, FiniteProgress progress) {
            Logging log = AbstractCutDendrogram.this.getLogger();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>();
            Metadata.of(dendrogram).setLongName("Hierarchical Clustering");
            Cluster<DendrogramModel> root = null;
            int n = this.merges.size();
            ArrayList<Cluster<DendrogramModel>> clusters = new ArrayList<Cluster<DendrogramModel>>(n - split);
            Int2IntOpenHashMap cmap = new Int2IntOpenHashMap(this.leafTop.size() << 1);
            cmap.defaultReturnValue(-1);
            for (int i = 0; i < this.leafTop.size; ++i) {
                int id = this.leafTop.get(i);
                clusters.add(this.makeCluster(id + n, (DBIDs)this.clusterMembers.get(i)));
                cmap.put(id + n, i);
            }
            DBIDVar tmp = DBIDUtil.newVar();
            int m = this.merges.numMerges();
            for (int i = split; i < m; ++i) {
                Cluster<DendrogramModel> clu;
                int ca;
                int a = this.merges.getMergeA(i);
                int b = this.merges.getMergeB(i);
                double depth = this.merges.getMergeHeight(i);
                int n2 = ca = a < n ? -1 : cmap.remove(a);
                if (ca >= 0) {
                    Cluster cla = (Cluster)clusters.get(ca);
                    if (((DendrogramModel)cla.getModel()).getDistance() == depth) {
                        if (b < n) {
                            if (AbstractCutDendrogram.this.simplify) {
                                cmap.put(i + n, ca);
                                clu = cla;
                                ((ModifiableDBIDs)clu.getIDs()).add((DBIDRef)this.merges.assignVar(b, tmp));
                            } else {
                                cmap.put(i + n, clusters.size() + 1);
                                clu = this.makeCluster(i + n, (DBIDs)DBIDUtil.EMPTYDBIDS);
                                clusters.add(clu);
                                dendrogram.addChildCluster(clu, cla);
                                dendrogram.addChildCluster(clu, this.makeCluster(b, (DBIDs)DBIDUtil.newArray((DBIDs)this.merges.assignVar(b, tmp))));
                            }
                        } else {
                            cmap.put(i + n, ca);
                            clu = cla;
                            dendrogram.addChildCluster(clu, (Cluster)clusters.get(cmap.remove(b)));
                        }
                    } else {
                        ArrayModifiableDBIDs ci = DBIDUtil.newArray((int)(b < n ? 1 : 0));
                        if (b < n) {
                            ci.add((DBIDRef)this.merges.assignVar(b, tmp));
                        }
                        cmap.put(i + n, clusters.size());
                        clu = this.makeCluster(i + n, (DBIDs)ci);
                        clusters.add(clu);
                        dendrogram.addChildCluster(clu, cla);
                        if (b >= n) {
                            dendrogram.addChildCluster(clu, (Cluster)clusters.get(cmap.remove(b)));
                        }
                    }
                } else if (b < n) {
                    ArrayModifiableDBIDs ci = DBIDUtil.newArray((int)2);
                    ci.add((DBIDRef)this.merges.assignVar(a, tmp));
                    ci.add((DBIDRef)this.merges.assignVar(b, tmp));
                    cmap.put(i + n, clusters.size());
                    clu = this.makeCluster(i + n, (DBIDs)ci);
                    clusters.add(clu);
                } else {
                    int cb = cmap.get(b);
                    Cluster<DendrogramModel> clb = (Cluster<DendrogramModel>)clusters.get(cb);
                    if (((DendrogramModel)clb.getModel()).getDistance() == depth) {
                        clu = clb;
                        ((ModifiableDBIDs)clu.getIDs()).add((DBIDRef)this.merges.assignVar(a, tmp));
                        cmap.put(i + n, cb);
                    } else {
                        cmap.put(i + n, clusters.size());
                        if (!AbstractCutDendrogram.this.simplify) {
                            clu = this.makeCluster(i + n, (DBIDs)DBIDUtil.EMPTYDBIDS);
                            clusters.add(clu);
                            dendrogram.addChildCluster(clu, this.makeCluster(a, (DBIDs)DBIDUtil.newArray((DBIDs)this.merges.assignVar(a, tmp))));
                        } else {
                            clu = this.makeCluster(i + n, (DBIDs)DBIDUtil.newArray((DBIDs)this.merges.assignVar(a, tmp)));
                            clusters.add(clu);
                        }
                        dendrogram.addChildCluster(clu, clb);
                    }
                }
                root = clu;
                log.incrementProcessed((AbstractProgress)progress);
            }
            dendrogram.addToplevelCluster(root);
            return dendrogram;
        }

        protected abstract int findSplit();

        protected Cluster<DendrogramModel> makeCluster(int seq, DBIDs members) {
            double depth;
            double d = depth = seq >= this.merges.size() ? this.merges.getMergeHeight(seq - this.merges.size()) : Double.NaN;
            String name = members.size() == 1 ? "obj_" + DBIDUtil.toString((DBIDRef)members.iter()) : (members.isEmpty() ? "mrg_" + depth : (depth < Double.POSITIVE_INFINITY ? "clu_" + depth : "top"));
            DendrogramModel model = !members.isEmpty() && this.merges instanceof ClusterPrototypeMergeHistory ? new PrototypeDendrogramModel(depth, ((ClusterPrototypeMergeHistory)this.merges).prototype(seq)) : new DendrogramModel(depth);
            return new Cluster<DendrogramModel>(name, members, model);
        }
    }
}

