/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.extraction;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.extraction.AbstractCutDendrogram;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;

public class CutDendrogramByHeight
extends AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(CutDendrogramByHeight.class);
    private final double threshold;

    public CutDendrogramByHeight(HierarchicalClusteringAlgorithm algorithm, double threshold, boolean hierarchical) {
        this(algorithm, threshold, hierarchical, true);
    }

    public CutDendrogramByHeight(HierarchicalClusteringAlgorithm algorithm, double threshold, boolean hierarchical, boolean simplify) {
        super(algorithm, hierarchical, simplify);
        this.threshold = threshold;
    }

    @Override
    public Clustering<DendrogramModel> run(ClusterMergeHistory merges) {
        Clustering<DendrogramModel> result = new Instance(merges).extractClusters();
        Metadata.hierarchyOf(result).addChild((Object)merges);
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractCutDendrogram.Par {
        public static final OptionID THRESHOLD_ID = new OptionID("hierarchical.threshold", "The threshold level for which to extract the clusters.");
        double threshold = Double.NaN;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            new DoubleParameter(THRESHOLD_ID).grab(config, x -> {
                this.threshold = x;
            });
        }

        public CutDendrogramByHeight make() {
            return new CutDendrogramByHeight(this.algorithm, this.threshold, this.hierarchical, this.simplify);
        }
    }

    protected class Instance
    extends AbstractCutDendrogram.Instance {
        public Instance(ClusterMergeHistory merges) {
            super(merges);
        }

        @Override
        protected int findSplit() {
            int split;
            for (split = this.merges.numMerges() - 1; split > 1 && CutDendrogramByHeight.this.threshold <= this.merges.getMergeHeight(split - 1); --split) {
            }
            return split;
        }
    }
}

