/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.extraction;

import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.clustering.hierarchical.extraction.AbstractCutDendrogram;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.logging.Logging;
import elki.result.Metadata;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;

public class CutDendrogramByNumberOfClusters
extends AbstractCutDendrogram
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    static final Logging LOG = Logging.getLogger(CutDendrogramByNumberOfClusters.class);
    private final int minclusters;

    public CutDendrogramByNumberOfClusters(HierarchicalClusteringAlgorithm algorithm, int minclusters, boolean hierarchical) {
        this(algorithm, minclusters, hierarchical, true);
    }

    public CutDendrogramByNumberOfClusters(HierarchicalClusteringAlgorithm algorithm, int minclusters, boolean hierarchical, boolean simplify) {
        super(algorithm, hierarchical, simplify);
        this.minclusters = minclusters;
    }

    @Override
    public Clustering<DendrogramModel> run(ClusterMergeHistory merges) {
        Clustering<DendrogramModel> result = new Instance(merges).extractClusters();
        Metadata.hierarchyOf(result).addChild((Object)merges);
        return result;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par
    extends AbstractCutDendrogram.Par {
        public static final OptionID MINCLUSTERS_ID = new OptionID("hierarchical.minclusters", "The minimum number of clusters to extract (there may be more clusters when tied, and singletons may be merged into a noise cluster).");
        int minclusters = -1;

        @Override
        public void configure(Parameterization config) {
            super.configure(config);
            ((IntParameter)new IntParameter(MINCLUSTERS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT)).grab(config, x -> {
                this.minclusters = x;
            });
        }

        public CutDendrogramByNumberOfClusters make() {
            return new CutDendrogramByNumberOfClusters(this.algorithm, this.minclusters, this.hierarchical, this.simplify);
        }
    }

    protected class Instance
    extends AbstractCutDendrogram.Instance {
        public Instance(ClusterMergeHistory merges) {
            super(CutDendrogramByNumberOfClusters.this, merges);
        }

        @Override
        protected int findSplit() {
            int split;
            if (this.merges.size() <= CutDendrogramByNumberOfClusters.this.minclusters) {
                return 0;
            }
            double stopdist = this.merges.getMergeHeight(split);
            for (split = this.merges.size() - CutDendrogramByNumberOfClusters.this.minclusters; split > 0 && stopdist == this.merges.getMergeHeight(split - 1); --split) {
            }
            return split;
        }
    }
}

