/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.extraction;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.ClusterDensityMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HDBSCANLinearMemory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.data.model.PrototypeDendrogramModel;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.DoubleDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.ids.DBIDMIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.io.FormatUtil;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.Flag;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;

@References(value={@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13"), @Reference(authors="R. J. G. B. Campello, D. Moulavi, A. Zimek, J. Sander", title="Hierarchical Density Estimates for Data Clustering, Visualization, and Outlier Detection", booktitle="ACM Trans. Knowl. Discov. Data 10(1)", url="https://doi.org/10.1145/2733381", bibkey="DBLP:journals/tkdd/CampelloMZS15")})
public class HDBSCANHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(HDBSCANHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;
    private boolean hierarchical = true;

    public HDBSCANHierarchyExtraction(HierarchicalClusteringAlgorithm algorithm, int minClSize, boolean hierarchical) {
        this.algorithm = algorithm;
        this.minClSize = minClSize;
        this.hierarchical = hierarchical;
    }

    @Override
    public Clustering<DendrogramModel> autorun(Database database) {
        return this.run(this.algorithm.autorun(database));
    }

    public Clustering<DendrogramModel> run(ClusterMergeHistory merges) {
        Clustering<DendrogramModel> result = new Instance(merges).run();
        Metadata.hierarchyOf(result).addChild((Object)merges);
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        public static final OptionID HIERARCHICAL_ID = new OptionID("hdbscan.hierarchical", "Produce a hierarchical output.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;
        boolean hierarchical = true;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class, HDBSCANLinearMemory.class).grab(config, x -> {
                this.algorithm = x;
            });
            ((IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minClSize = x;
            });
            new Flag(HIERARCHICAL_ID).grab(config, x -> {
                this.hierarchical = x;
            });
        }

        public HDBSCANHierarchyExtraction make() {
            return new HDBSCANHierarchyExtraction(this.algorithm, this.minClSize, this.hierarchical);
        }
    }

    private static class TempCluster {
        protected int seq;
        protected ModifiableDBIDs members = DBIDUtil.newArray();
        protected double dist = 0.0;
        protected double dmin = 0.0;
        protected double aggregate = 0.0;
        protected int childrenTotal = 0;
        protected Collection<TempCluster> children = new ArrayList<TempCluster>();

        public TempCluster(int seq, double dist, DBIDRef a) {
            this.seq = seq;
            this.dist = this.dmin = dist;
            this.members.add(a);
            this.aggregate = 1.0 / dist;
        }

        public TempCluster(int seq, double dist, TempCluster a, TempCluster b) {
            this.seq = seq;
            this.dist = dist;
            this.dmin = a.dmin < b.dmin ? a.dmin : b.dmin;
            this.children.add(a);
            this.children.add(b);
            this.childrenTotal = a.totalElements() + b.totalElements();
            this.aggregate = (double)this.childrenTotal / dist;
        }

        public TempCluster grow(int seq, double dist, TempCluster other) {
            this.seq = seq;
            this.dist = dist;
            double d = this.dmin = this.dmin < other.dmin ? this.dmin : other.dmin;
            assert (other.children.isEmpty());
            this.members.addDBIDs((DBIDs)other.members);
            this.aggregate += (double)other.members.size() / dist;
            other.members = null;
            other.children = null;
            return this;
        }

        public TempCluster grow(int seq, double dist, DBIDRef id) {
            this.seq = seq;
            this.dist = this.dmin = dist;
            this.members.add(id);
            this.aggregate += 1.0 / dist;
            return this;
        }

        public TempCluster resetAggregate() {
            this.aggregate = (double)this.totalElements() / this.dist;
            this.dmin = this.dist;
            return this;
        }

        public int totalElements() {
            return this.childrenTotal + this.members.size();
        }

        public double excessOfMass() {
            return this.aggregate - (double)this.totalElements() / this.dist;
        }

        public double totalStability() {
            double stability = this.excessOfMass();
            double cstab = 0.0;
            for (TempCluster child : this.children) {
                cstab += Math.abs(child.totalStability());
            }
            return stability > cstab ? stability : -cstab;
        }

        public boolean isSpurious(int minClSize) {
            return this.children.isEmpty() && this.members.size() < minClSize;
        }
    }

    protected class Instance {
        protected ClusterMergeHistory merges;
        protected DoubleDataStore coredist;

        public Instance(ClusterMergeHistory merges) {
            this.merges = merges;
            if (merges instanceof ClusterDensityMergeHistory) {
                this.coredist = ((ClusterDensityMergeHistory)merges).getCoreDistanceStore();
            }
        }

        public Clustering<DendrogramModel> run() {
            Int2ObjectOpenHashMap cluster_map = new Int2ObjectOpenHashMap(this.merges.size() >> 1);
            DBIDVar tmp = DBIDUtil.newVar();
            int n = this.merges.size();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", this.merges.numMerges(), LOG) : null;
            int m = this.merges.numMerges();
            for (int i = 0; i < m; ++i) {
                TempCluster nclus;
                double dist = this.merges.getMergeHeight(i);
                int a = this.merges.getMergeA(i);
                int b = this.merges.getMergeB(i);
                TempCluster cclus = (TempCluster)cluster_map.remove(a);
                double cdist = this.coredist != null && a < n ? this.coredist.doubleValue((DBIDRef)this.merges.assignVar(a, tmp)) : dist;
                boolean cSpurious = this.isSpurious(cclus, cdist <= dist);
                TempCluster oclus = (TempCluster)cluster_map.remove(b);
                double odist = this.coredist != null && b < n ? this.coredist.doubleValue((DBIDRef)this.merges.assignVar(b, tmp)) : dist;
                boolean oSpurious = this.isSpurious(oclus, odist <= dist);
                if (!cSpurious && !oSpurious) {
                    assert (cclus != null || a < n);
                    assert (oclus != null || b < n);
                    cclus = cclus != null ? cclus : new TempCluster(a, cdist, (DBIDRef)this.merges.assignVar(a, tmp));
                    oclus = oclus != null ? oclus : new TempCluster(b, odist, (DBIDRef)this.merges.assignVar(b, tmp));
                    nclus = new TempCluster(i, dist, oclus, cclus);
                } else if (!oSpurious && oclus != null) {
                    nclus = a < n ? oclus.grow(i, dist, (DBIDRef)this.merges.assignVar(a, tmp)) : oclus.grow(i, dist, cclus);
                } else if (!cSpurious && cclus != null) {
                    nclus = b < n ? cclus.grow(i, dist, (DBIDRef)this.merges.assignVar(b, tmp)) : cclus.grow(i, dist, oclus);
                } else if (oclus != null) {
                    nclus = (a < n ? oclus.grow(i, dist, (DBIDRef)this.merges.assignVar(a, tmp)) : oclus.grow(i, dist, cclus)).resetAggregate();
                } else if (cclus != null) {
                    nclus = (b < n ? cclus.grow(i, dist, (DBIDRef)this.merges.assignVar(b, tmp)) : cclus.grow(i, dist, oclus)).resetAggregate();
                } else {
                    assert (a < n && b < n);
                    nclus = new TempCluster(i, dist, (DBIDRef)this.merges.assignVar(a, tmp));
                    nclus.members.add((DBIDRef)this.merges.assignVar(b, tmp));
                }
                assert (nclus != null);
                cluster_map.put(i + n, (Object)nclus);
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
            WritableDoubleDataStore glosh = DataStoreUtil.makeDoubleStorage((DBIDs)this.merges.getDBIDs(), (int)3);
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>();
            Metadata.of(dendrogram).setLongName("Hierarchical Clustering");
            for (TempCluster clus : cluster_map.values()) {
                this.finalizeCluster(clus, dendrogram, glosh, null, false);
            }
            Metadata.hierarchyOf(dendrogram).addChild((Object)glosh);
            return dendrogram;
        }

        private boolean isSpurious(TempCluster clus, boolean isCore) {
            return clus != null ? clus.isSpurious(HDBSCANHierarchyExtraction.this.minClSize) : HDBSCANHierarchyExtraction.this.minClSize > 1 || !isCore;
        }

        private double finalizeCluster(TempCluster temp, Clustering<DendrogramModel> clustering, WritableDoubleDataStore glosh, Cluster<DendrogramModel> parent, boolean flatten) {
            String name = "C_" + FormatUtil.NF6.format(temp.dist);
            DendrogramModel model = temp.members != null && !temp.members.isEmpty() && this.merges instanceof ClusterPrototypeMergeHistory ? new PrototypeDendrogramModel(temp.dist, ((ClusterPrototypeMergeHistory)this.merges).prototype(temp.seq)) : new DendrogramModel(temp.dist);
            Cluster<DendrogramModel> clus = new Cluster<DendrogramModel>(name, (DBIDs)temp.members, model);
            if (HDBSCANHierarchyExtraction.this.hierarchical && parent != null) {
                clustering.addChildCluster(parent, clus);
            } else {
                clustering.addToplevelCluster(clus);
            }
            double dmin = this.collectChildren(temp, clustering, glosh, temp, clus, flatten);
            DBIDMIter it = temp.members.iter();
            while (it.valid()) {
                double cdist = this.coredist != null ? this.coredist.doubleValue((DBIDRef)it) : temp.dist;
                double d = cdist = cdist >= dmin ? cdist : dmin;
                assert (HDBSCANHierarchyExtraction.this.minClSize > 2 || dmin <= cdist) : dmin + " > " + cdist;
                glosh.put((DBIDRef)it, cdist > 0.0 ? 1.0 - dmin / cdist : 0.0);
                it.advance();
            }
            temp.members = null;
            temp.children = null;
            return dmin;
        }

        private double collectChildren(TempCluster temp, Clustering<DendrogramModel> clustering, WritableDoubleDataStore glosh, TempCluster cur, Cluster<DendrogramModel> clus, boolean flatten) {
            double dmin = cur.dmin;
            for (TempCluster child : cur.children) {
                double cdmin;
                if (flatten || child.totalStability() < 0.0) {
                    temp.members.addDBIDs((DBIDs)child.members);
                    cdmin = this.collectChildren(temp, clustering, glosh, child, clus, flatten);
                } else {
                    cdmin = this.finalizeCluster(child, clustering, glosh, clus, true);
                }
                dmin = dmin < cdmin ? dmin : cdmin;
            }
            return dmin;
        }
    }
}

