/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.extraction;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.clustering.hierarchical.ClusterDensityMergeHistory;
import elki.clustering.hierarchical.ClusterMergeHistory;
import elki.clustering.hierarchical.ClusterPrototypeMergeHistory;
import elki.clustering.hierarchical.HierarchicalClusteringAlgorithm;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.DendrogramModel;
import elki.data.model.PrototypeDendrogramModel;
import elki.data.type.TypeInformation;
import elki.database.Database;
import elki.database.datastore.DoubleDataStore;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.result.Metadata;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;

@Reference(authors="R. J. G. B. Campello, D. Moulavi, J. Sander", title="Density-Based Clustering Based on Hierarchical Density Estimates", booktitle="Pacific-Asia Conf. Advances in Knowledge Discovery and Data Mining (PAKDD)", url="https://doi.org/10.1007/978-3-642-37456-2_14", bibkey="DBLP:conf/pakdd/CampelloMS13")
@Priority(value=205)
public class SimplifiedHierarchyExtraction
implements ClusteringAlgorithm<Clustering<DendrogramModel>> {
    private static final Logging LOG = Logging.getLogger(SimplifiedHierarchyExtraction.class);
    private int minClSize = 1;
    private HierarchicalClusteringAlgorithm algorithm;

    public SimplifiedHierarchyExtraction(HierarchicalClusteringAlgorithm algorithm, int minClSize) {
        this.algorithm = algorithm;
        this.minClSize = minClSize;
    }

    @Override
    public Clustering<DendrogramModel> autorun(Database database) {
        return this.run(this.algorithm.autorun(database));
    }

    public Clustering<DendrogramModel> run(ClusterMergeHistory merges) {
        Clustering<DendrogramModel> result = new Instance(merges).run();
        Metadata.hierarchyOf(result).addChild((Object)merges);
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID MINCLUSTERSIZE_ID = new OptionID("hdbscan.minclsize", "The minimum cluster size.");
        int minClSize = 1;
        HierarchicalClusteringAlgorithm algorithm;

        public void configure(Parameterization config) {
            new ObjectParameter(Algorithm.Utils.ALGORITHM_ID, HierarchicalClusteringAlgorithm.class).grab(config, x -> {
                this.algorithm = x;
            });
            ((IntParameter)new IntParameter(MINCLUSTERSIZE_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.minClSize = x;
            });
        }

        public SimplifiedHierarchyExtraction make() {
            return new SimplifiedHierarchyExtraction(this.algorithm, this.minClSize);
        }
    }

    private static class TempCluster {
        protected int seq;
        protected ModifiableDBIDs newids = DBIDUtil.newArray();
        protected double depth = 0.0;
        protected Collection<Cluster<DendrogramModel>> children = new ArrayList<Cluster<DendrogramModel>>();

        public TempCluster(int seq, double depth) {
            this.seq = seq;
            this.depth = depth;
        }

        public void add(DBIDRef id) {
            this.newids.add(id);
        }

        public void addDBIDs(DBIDs ids) {
            this.newids.addDBIDs(ids);
        }

        public void addChild(Cluster<DendrogramModel> clu) {
            this.children.add(clu);
        }

        public boolean isNotSpurious(int minClSize) {
            return !this.children.isEmpty() || this.newids.size() >= minClSize;
        }
    }

    protected class Instance {
        protected ClusterMergeHistory merges;
        protected DoubleDataStore coredist = null;

        public Instance(ClusterMergeHistory merges) {
            this.merges = merges;
            if (merges instanceof ClusterDensityMergeHistory) {
                this.coredist = ((ClusterDensityMergeHistory)merges).getCoreDistanceStore();
            }
        }

        public Clustering<DendrogramModel> run() {
            Int2ObjectOpenHashMap cluster_map = new Int2ObjectOpenHashMap(this.merges.size() >> 1);
            DBIDVar tmp = DBIDUtil.newVar();
            int n = this.merges.size();
            Clustering<DendrogramModel> dendrogram = new Clustering<DendrogramModel>();
            FiniteProgress progress = LOG.isVerbose() ? new FiniteProgress("Extracting clusters", this.merges.numMerges(), LOG) : null;
            int m = this.merges.numMerges();
            for (int i = 0; i < m; ++i) {
                TempCluster nclus;
                boolean bNotSpurious;
                boolean bIsCore;
                boolean aIsCore;
                double dist = this.merges.getMergeHeight(i);
                int a = this.merges.getMergeA(i);
                int b = this.merges.getMergeB(i);
                TempCluster aclus = (TempCluster)cluster_map.remove(a);
                boolean bl = aIsCore = this.coredist == null || a >= n || dist >= this.coredist.doubleValue((DBIDRef)this.merges.assignVar(a, tmp));
                boolean aNotSpurious = aclus != null ? aclus.isNotSpurious(SimplifiedHierarchyExtraction.this.minClSize) : SimplifiedHierarchyExtraction.this.minClSize <= 1 && aIsCore;
                TempCluster bclus = (TempCluster)cluster_map.remove(b);
                boolean bl2 = bIsCore = this.coredist == null || b >= n || dist <= this.coredist.doubleValue((DBIDRef)this.merges.assignVar(b, tmp));
                boolean bl3 = bclus != null ? bclus.isNotSpurious(SimplifiedHierarchyExtraction.this.minClSize) : (bNotSpurious = SimplifiedHierarchyExtraction.this.minClSize <= 1 && bIsCore);
                if (bclus != null && aclus != null) {
                    if (bNotSpurious && aNotSpurious) {
                        bclus.addChild(this.toCluster(bclus, dendrogram));
                        bclus.addChild(this.toCluster(aclus, dendrogram));
                        assert (bclus.children.size() == 2);
                        nclus = bclus;
                    } else if (aNotSpurious) {
                        aclus.addDBIDs((DBIDs)bclus.newids);
                        assert (bclus.children.isEmpty());
                        nclus = aclus;
                    } else {
                        bclus.addDBIDs((DBIDs)aclus.newids);
                        assert (aclus.children.isEmpty());
                        nclus = bclus;
                    }
                    nclus.depth = dist;
                } else if (aclus != null) {
                    if (aNotSpurious && bNotSpurious) {
                        aclus.addChild(this.toCluster(aclus, dendrogram));
                    }
                    this.addSingleton(aclus, b, (DBIDRef)this.merges.assignVar(b, tmp), dist, bNotSpurious);
                    nclus = aclus;
                } else if (bclus != null) {
                    if (aNotSpurious && bNotSpurious) {
                        bclus.addChild(this.toCluster(bclus, dendrogram));
                    }
                    this.addSingleton(bclus, a, (DBIDRef)this.merges.assignVar(a, tmp), dist, aNotSpurious);
                    nclus = bclus;
                } else {
                    nclus = new TempCluster(i + n, dist);
                    this.addSingleton(nclus, a, (DBIDRef)this.merges.assignVar(a, tmp), dist, aNotSpurious);
                    this.addSingleton(nclus, b, (DBIDRef)this.merges.assignVar(b, tmp), dist, bNotSpurious);
                }
                assert (nclus != null);
                cluster_map.put(i + n, (Object)nclus);
                LOG.incrementProcessed((AbstractProgress)progress);
            }
            LOG.ensureCompleted(progress);
            for (TempCluster clus : cluster_map.values()) {
                dendrogram.addToplevelCluster(this.toCluster(clus, dendrogram));
            }
            Metadata.of(dendrogram).setLongName("Hierarchical Clustering");
            return dendrogram;
        }

        private void addSingleton(TempCluster clus, int id, DBIDRef it, double dist, boolean asCluster) {
            if (asCluster) {
                clus.addChild(this.makeCluster(id, dist, (DBIDs)DBIDUtil.deref((DBIDRef)it)));
            } else {
                clus.add(it);
            }
            clus.depth = dist;
        }

        protected Cluster<DendrogramModel> toCluster(TempCluster temp, Clustering<DendrogramModel> clustering) {
            Cluster<DendrogramModel> cluster = this.makeCluster(temp.seq, temp.depth, (DBIDs)DBIDUtil.newArray((DBIDs)temp.newids));
            for (Cluster<DendrogramModel> child : temp.children) {
                clustering.addChildCluster(cluster, child);
            }
            temp.newids.clear();
            temp.children.clear();
            return cluster;
        }

        protected Cluster<DendrogramModel> makeCluster(int seq, double depth, DBIDs members) {
            Object object = members = members != null ? members : DBIDUtil.EMPTYDBIDS;
            String name = members.size() == 1 ? "obj_" + DBIDUtil.toString((DBIDRef)members.iter()) : (members.isEmpty() ? "mrg_" + depth : (depth < Double.POSITIVE_INFINITY ? "clu_" + depth : "top"));
            DendrogramModel model = !members.isEmpty() && this.merges instanceof ClusterPrototypeMergeHistory ? new PrototypeDendrogramModel(depth, ((ClusterPrototypeMergeHistory)this.merges).prototype(seq)) : new DendrogramModel(depth);
            return new Cluster<DendrogramModel>(name, members, model);
        }
    }
}

