/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.GeometricLinkage;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.linearalgebra.VMath;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="J. C. Gower", title="A comparison of some methods of cluster analysis", booktitle="Biometrics (1967)", url="https://doi.org/10.2307/2528417", bibkey="doi:10.2307/2528417")
@Alias(value={"centroid", "upgmc"})
public class CentroidLinkage
implements GeometricLinkage {
    public static final CentroidLinkage STATIC = new CentroidLinkage();

    @Deprecated
    public CentroidLinkage() {
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        double f = 1.0 / (double)(sizex + sizey);
        return ((double)sizex * dx + (double)sizey * dy - (double)(sizex * sizey) * f * dxy) * f;
    }

    @Override
    public double[] merge(double[] x, int sizex, double[] y, int sizey) {
        return VMath.timesPlusTimes((double[])x, (double)((double)sizex / (double)(sizex + sizey)), (double[])y, (double)((double)sizey / (double)(sizex + sizey)));
    }

    @Override
    public double distance(double[] x, int sizex, double[] y, int sizey) {
        return SquaredEuclideanDistance.STATIC.distance(x, y);
    }

    public static class Par
    implements Parameterizer {
        public CentroidLinkage make() {
            return STATIC;
        }
    }
}

