/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.Linkage;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.GreaterConstraint;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.DoubleParameter;

@Reference(authors="G. N. Lance, W. T. Williams", title="A general theory of classificatory sorting strategies 1. Hierarchical systems", booktitle="The Computer Journal 9.4", url="https://doi.org/10.1093/comjnl/9.4.373", bibkey="doi:10.1093/comjnl/9.4.373")
@Alias(value={"flex", "beta"})
@Priority(value=-2)
public class FlexibleBetaLinkage
implements Linkage {
    double alpha;
    double beta;

    public FlexibleBetaLinkage(double beta) {
        this.alpha = 0.5 * (1.0 - beta);
        this.beta = beta;
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return this.alpha * dx + this.alpha * dy + this.beta * dxy;
    }

    public static class Par
    implements Parameterizer {
        public static final OptionID BETA_ID = new OptionID("lancewilliams.beta", "Beta for the Lance-Williams flexible beta approach.");
        double beta;

        public void configure(Parameterization config) {
            ((DoubleParameter)((DoubleParameter)new DoubleParameter(BETA_ID, -0.25).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE)).addConstraint((ParameterConstraint)new GreaterConstraint(-1.0))).grab(config, x -> {
                this.beta = x;
            });
        }

        public FlexibleBetaLinkage make() {
            return new FlexibleBetaLinkage(this.beta);
        }
    }
}

