/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.Linkage;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="R. R. Sokal, C. D. Michener", title="A statistical method for evaluating systematic relationship", booktitle="University of Kansas science bulletin 28", url="https://archive.org/details/cbarchive_33927_astatisticalmethodforevaluatin1902", bibkey="journals/kansas/SokalM1902")
@Alias(value={"upgma", "average", "average-link", "average-linkage", "UPGMA"})
@Priority(value=201)
public class GroupAverageLinkage
implements Linkage {
    public static final GroupAverageLinkage STATIC = new GroupAverageLinkage();

    @Deprecated
    public GroupAverageLinkage() {
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return ((double)sizex * dx + (double)sizey * dy) / (double)(sizex + sizey);
    }

    public static class Par
    implements Parameterizer {
        public GroupAverageLinkage make() {
            return STATIC;
        }
    }
}

