/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.GeometricLinkage;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.linearalgebra.VMath;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="J. C. Gower", title="A comparison of some methods of cluster analysis", booktitle="Biometrics (1967)", url="https://doi.org/10.2307/2528417", bibkey="doi:10.2307/2528417")
@Alias(value={"wpgmc", "WPGMC", "weighted-centroid"})
public class MedianLinkage
implements GeometricLinkage {
    public static final MedianLinkage STATIC = new MedianLinkage();

    @Deprecated
    public MedianLinkage() {
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return 0.5 * (dx + dy) - 0.25 * dxy;
    }

    @Override
    public double[] merge(double[] x, int sizex, double[] y, int sizey) {
        return VMath.timesPlusTimes((double[])x, (double)0.5, (double[])y, (double)0.5);
    }

    @Override
    public double distance(double[] x, int sizex, double[] y, int sizey) {
        return SquaredEuclideanDistance.STATIC.distance(x, y);
    }

    public static class Par
    implements Parameterizer {
        public MedianLinkage make() {
            return STATIC;
        }
    }
}

