/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.Linkage;
import elki.utilities.Alias;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;

@References(value={@Reference(authors="J. Podani", title="New Combinatorial Clustering Methods", booktitle="Vegetatio 81(1/2)", url="https://doi.org/10.1007/978-94-009-2432-1_5", bibkey="doi:10.1007/978-94-009-2432-1_5"), @Reference(authors="E. Diday, J. Lemaire, J. Pouget, F. Testu", title="Elements d'analyse de donnees", booktitle="", bibkey="books/misc/DidayLPT85")})
@Alias(value={"variance"})
public class MinimumVarianceLinkage
implements Linkage {
    public static final MinimumVarianceLinkage STATIC = new MinimumVarianceLinkage();

    @Deprecated
    public MinimumVarianceLinkage() {
    }

    @Override
    public double initial(double d, boolean issquare) {
        return 0.25 * (issquare ? d : d * d);
    }

    @Override
    public double restore(double d, boolean issquare) {
        return issquare ? 4.0 * d : Math.sqrt(4.0 * d);
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        int xj = sizex + sizej;
        int yj = sizey + sizej;
        int n = sizex + sizey + sizej;
        return ((double)xj * (double)xj * dx + (double)yj * (double)yj * dy - (double)sizej * (double)(sizex + sizey) * dxy) / ((double)n * (double)n);
    }

    public static class Par
    implements Parameterizer {
        public MinimumVarianceLinkage make() {
            return STATIC;
        }
    }
}

