/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.GeometricLinkage;
import elki.distance.minkowski.SquaredEuclideanDistance;
import elki.math.linearalgebra.VMath;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.optionhandling.Parameterizer;

@References(value={@Reference(authors="J. H. Ward Jr.", title="Hierarchical grouping to optimize an objective function", booktitle="Journal of the American statistical association 58.301", url="https://doi.org/10.1080/01621459.1963.10500845", bibkey="doi:10.1080/01621459.1963.10500845"), @Reference(authors="D. Wishart", title="256. Note: An Algorithm for Hierarchical Classifications", booktitle="Biometrics 25(1)", url="https://doi.org/10.2307/2528688", bibkey="doi:10.2307/2528688")})
@Alias(value={"ward", "MISSQ"})
@Priority(value=101)
public class WardLinkage
implements GeometricLinkage {
    public static final WardLinkage STATIC = new WardLinkage();

    @Deprecated
    public WardLinkage() {
    }

    @Override
    public double initial(double d, boolean issquare) {
        return 0.5 * (issquare ? d : d * d);
    }

    @Override
    public double restore(double d, boolean issquare) {
        return issquare ? 2.0 * d : Math.sqrt(2.0 * d);
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return ((double)(sizex + sizej) * dx + (double)(sizey + sizej) * dy - (double)sizej * dxy) / (double)(sizex + sizey + sizej);
    }

    @Override
    public double[] merge(double[] x, int sizex, double[] y, int sizey) {
        return VMath.timesPlusTimes((double[])x, (double)((double)sizex / (double)(sizex + sizey)), (double[])y, (double)((double)sizey / (double)(sizex + sizey)));
    }

    @Override
    public double distance(double[] x, int sizex, double[] y, int sizey) {
        return (double)(sizex * sizey) / (double)(sizex + sizey) * SquaredEuclideanDistance.STATIC.distance(x, y);
    }

    public static class Par
    implements Parameterizer {
        public WardLinkage make() {
            return STATIC;
        }
    }
}

