/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.hierarchical.linkage;

import elki.clustering.hierarchical.linkage.Linkage;
import elki.utilities.Alias;
import elki.utilities.Priority;
import elki.utilities.documentation.Reference;
import elki.utilities.optionhandling.Parameterizer;

@Reference(authors="R. R. Sokal, C. D. Michener", title="A statistical method for evaluating systematic relationship", booktitle="University of Kansas science bulletin 28", url="https://archive.org/details/cbarchive_33927_astatisticalmethodforevaluatin1902", bibkey="journals/kansas/SokalM1902")
@Alias(value={"wpgma", "WPGMA"})
@Priority(value=-1)
public class WeightedAverageLinkage
implements Linkage {
    public static final WeightedAverageLinkage STATIC = new WeightedAverageLinkage();

    @Deprecated
    public WeightedAverageLinkage() {
    }

    @Override
    public double combine(int sizex, double dx, int sizey, double dy, int sizej, double dxy) {
        return 0.5 * (dx + dy);
    }

    public static class Par
    implements Parameterizer {
        public WeightedAverageLinkage make() {
            return STATIC;
        }
    }
}

