/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kcenter;

import elki.Algorithm;
import elki.clustering.ClusteringAlgorithm;
import elki.clustering.ClusteringAlgorithmUtil;
import elki.data.Cluster;
import elki.data.Clustering;
import elki.data.model.SimplePrototypeModel;
import elki.data.type.TypeInformation;
import elki.database.datastore.DataStoreFactory;
import elki.database.datastore.IntegerDataStore;
import elki.database.datastore.WritableDoubleDataStore;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.ArrayModifiableDBIDs;
import elki.database.ids.DBIDArrayMIter;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDUtil;
import elki.database.ids.DBIDVar;
import elki.database.ids.DBIDs;
import elki.database.query.distance.DistanceQuery;
import elki.database.relation.Relation;
import elki.distance.Distance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import elki.utilities.documentation.Title;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;
import elki.utilities.optionhandling.parameters.RandomParameter;
import elki.utilities.random.RandomFactory;

@Title(value="Greedy K-center Clustering")
@References(value={@Reference(authors="T. F. Gonzalez", title="Clustering to Minimize the Maximum Intercluster Distance", booktitle="Theoretical Computer Science, 38", url="https://doi.org/10.1016/0304-3975(85)90224-5", bibkey="DBLP:journals/tcs/Gonzalez85"), @Reference(authors="D. S. Hochbaum, D. B. Shmoys", title="A unified approach to approximation algorithms for bottleneck problems", booktitle="Journal of the ACM, 33 (3), 1986", url="https://doi.org/10.1145/5925.5933", bibkey="DBLP:journals/jacm/HochbaumS86")})
public class GreedyKCenter<O>
implements ClusteringAlgorithm<Clustering<SimplePrototypeModel<O>>> {
    private static final Logging LOG = Logging.getLogger(GreedyKCenter.class);
    Distance<? super O> distance;
    int k;
    RandomFactory rand;

    public GreedyKCenter(int k, Distance<? super O> distance, RandomFactory rand) {
        this.k = k;
        this.distance = distance;
        this.rand = rand;
    }

    public Clustering<SimplePrototypeModel<O>> run(Relation<O> relation) {
        if (relation.size() == 0) {
            throw new IllegalArgumentException("database empty: must contain elements");
        }
        DBIDs ids = relation.getDBIDs();
        FiniteProgress progCluster = LOG.isVerbose() ? new FiniteProgress("Greedy k-center number of clusters", this.k, LOG) : null;
        FiniteProgress progDist = LOG.isVerbose() ? new FiniteProgress("Greedy k-center distance computations", this.k * ids.size(), LOG) : null;
        DistanceQuery distq = this.distance.instantiate(relation);
        WritableDoubleDataStore distanceToHead = DataStoreFactory.FACTORY.makeDoubleStorage(ids, 3, Double.POSITIVE_INFINITY);
        WritableIntegerDataStore clusAssignments = DataStoreFactory.FACTORY.makeIntegerStorage(ids, 3, 0);
        ArrayModifiableDBIDs heads = DBIDUtil.newArray((int)this.k);
        DBIDVar curHead = DBIDUtil.newVar();
        DBIDVar nextHead = DBIDUtil.randomSample((DBIDs)ids, (RandomFactory)this.rand);
        for (int i = 0; i < this.k; ++i) {
            curHead.set((DBIDRef)nextHead);
            double maxd = 0.0;
            clusAssignments.putInt((DBIDRef)curHead, i);
            heads.add((DBIDRef)curHead);
            DBIDIter it = ids.iter();
            while (it.valid()) {
                double od;
                double d = distq.distance((DBIDRef)curHead, (DBIDRef)it);
                if (d < (od = distanceToHead.doubleValue((DBIDRef)it))) {
                    od = d;
                    distanceToHead.putDouble((DBIDRef)it, od);
                    clusAssignments.putInt((DBIDRef)it, i);
                }
                if (maxd < od) {
                    maxd = od;
                    nextHead.set((DBIDRef)it);
                }
                LOG.incrementProcessed((AbstractProgress)progDist);
                it.advance();
            }
            LOG.incrementProcessed((AbstractProgress)progCluster);
        }
        LOG.ensureCompleted(progDist);
        LOG.ensureCompleted(progCluster);
        Clustering<SimplePrototypeModel<O>> result = new Clustering<SimplePrototypeModel<O>>();
        ArrayModifiableDBIDs[] clusters = ClusteringAlgorithmUtil.partitionsFromIntegerLabels(ids, (IntegerDataStore)clusAssignments, this.k);
        DBIDArrayMIter headsit = heads.iter();
        while (headsit.valid()) {
            result.addToplevelCluster(new Cluster<SimplePrototypeModel<Object>>((DBIDs)clusters[headsit.getOffset()], new SimplePrototypeModel<Object>(relation.get((DBIDRef)headsit))));
            headsit.advance();
        }
        return result;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return new TypeInformation[]{this.distance.getInputTypeRestriction()};
    }

    public static class Par<O>
    implements Parameterizer {
        public static final OptionID K_ID = new OptionID("greedy.k", "Number of centers to choose.");
        public static final OptionID RANDOM_ID = new OptionID("greedy.seed", "Random seed to use for choosing the first.");
        Distance<? super O> distance;
        int k;
        RandomFactory rand;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.k = x;
            });
            new ObjectParameter(Algorithm.Utils.DISTANCE_FUNCTION_ID, Distance.class, EuclideanDistance.class).grab(config, x -> {
                this.distance = x;
            });
            new RandomParameter(RANDOM_ID).grab(config, x -> {
                this.rand = x;
            });
        }

        public GreedyKCenter<O> make() {
            return new GreedyKCenter<O>(this.k, this.distance, this.rand);
        }
    }
}

