/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.AbstractKMeans;
import elki.clustering.kmeans.HamerlyKMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.KMeansModel;
import elki.database.datastore.DataStoreUtil;
import elki.database.datastore.WritableIntegerDataStore;
import elki.database.ids.DBIDIter;
import elki.database.ids.DBIDRef;
import elki.database.ids.DBIDs;
import elki.database.ids.ModifiableDBIDs;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.distance.minkowski.EuclideanDistance;
import elki.logging.Logging;
import elki.math.linearalgebra.VMath;
import elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;
import elki.utilities.documentation.Reference;
import elki.utilities.documentation.References;
import java.util.Arrays;

@References(value={@Reference(authors="J. Drake", title="Faster k-means clustering", booktitle="Faster k-means clustering", url="http://hdl.handle.net/2104/8826", bibkey="mathesis/Drake13"), @Reference(authors="G. Hamerly and J. Drake", title="Accelerating Lloyd\u2019s Algorithm for k-Means Clustering", booktitle="Partitional Clustering Algorithms", url="https://doi.org/10.1007/978-3-319-09259-1_2", bibkey="doi:10.1007/978-3-319-09259-1_2")})
public class AnnulusKMeans<V extends NumberVector>
extends HamerlyKMeans<V> {
    private static final Logging LOG = Logging.getLogger(AnnulusKMeans.class);

    public AnnulusKMeans(NumberVectorDistance<? super V> distance, int k, int maxiter, KMeansInitialization initializer, boolean varstat) {
        super(distance, k, maxiter, initializer, varstat);
    }

    @Override
    public Clustering<KMeansModel> run(Relation<V> relation) {
        Instance instance = new Instance(relation, this.distance, this.initialMeans(relation));
        instance.run(this.maxiter);
        return instance.buildResult(this.varstat, relation);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Par<V extends NumberVector>
    extends HamerlyKMeans.Par<V> {
        @Override
        public AnnulusKMeans<V> make() {
            return new AnnulusKMeans(this.distance, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }

    protected static class Instance
    extends HamerlyKMeans.Instance {
        WritableIntegerDataStore second;
        double[] cdist;
        int[] cnum;

        public Instance(Relation<? extends NumberVector> relation, NumberVectorDistance<?> df, double[][] means) {
            super(relation, df, means);
            this.second = DataStoreUtil.makeIntegerStorage((DBIDs)relation.getDBIDs(), (int)3, (int)-1);
            this.cdist = new double[this.k];
            this.cnum = new int[this.k];
        }

        @Override
        protected int initialAssignToNearestCluster() {
            assert (this.k == this.means.length);
            double[][] sep2 = new double[this.k][this.k];
            this.computeSquaredSeparation(sep2);
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                double min1 = this.distance(fv, this.means[0]);
                double min2 = this.k > 1 ? this.distance(fv, this.means[1]) : min1;
                int minIndex = 0;
                int secIndex = 1;
                if (min2 < min1) {
                    double tmp = min1;
                    min1 = min2;
                    min2 = tmp;
                    minIndex = 1;
                    secIndex = 0;
                }
                for (int i = 2; i < this.k; ++i) {
                    if (!(min2 > sep2[minIndex][i])) continue;
                    double dist = this.distance(fv, this.means[i]);
                    if (dist < min1) {
                        secIndex = minIndex;
                        minIndex = i;
                        min2 = min1;
                        min1 = dist;
                        continue;
                    }
                    if (!(dist < min2)) continue;
                    secIndex = i;
                    min2 = dist;
                }
                ((ModifiableDBIDs)this.clusters.get(minIndex)).add((DBIDRef)it);
                this.assignment.putInt((DBIDRef)it, minIndex);
                this.second.putInt((DBIDRef)it, secIndex);
                AbstractKMeans.plusEquals(this.sums[minIndex], fv);
                this.upper.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min1) : min1);
                this.lower.putDouble((DBIDRef)it, this.isSquared ? Math.sqrt(min2) : min2);
                it.advance();
            }
            return this.relation.size();
        }

        protected void orderMeans() {
            int k = this.cdist.length;
            assert (this.sep.length == k);
            Arrays.fill(this.sep, Double.POSITIVE_INFINITY);
            for (int i = 0; i < k; ++i) {
                double[] mi = this.means[i];
                this.cdist[i] = VMath.euclideanLength((double[])mi);
                this.cnum[i] = i;
                for (int j = 0; j < i; ++j) {
                    double halfd = 0.5 * this.sqrtdistance(mi, this.means[j]);
                    this.sep[i] = halfd < this.sep[i] ? halfd : this.sep[i];
                    this.sep[j] = halfd < this.sep[j] ? halfd : this.sep[j];
                }
            }
            DoubleIntegerArrayQuickSort.sort((double[])this.cdist, (int[])this.cnum, (int)k);
        }

        @Override
        protected int assignToNearestCluster() {
            assert (this.k == this.means.length);
            this.orderMeans();
            int changed = 0;
            DBIDIter it = this.relation.iterDBIDs();
            while (it.valid()) {
                int orig = this.assignment.intValue((DBIDRef)it);
                double z = this.lower.doubleValue((DBIDRef)it);
                double sa = this.sep[orig];
                double u = this.upper.doubleValue((DBIDRef)it);
                if (!(u <= z) && !(u <= sa)) {
                    NumberVector fv = (NumberVector)this.relation.get((DBIDRef)it);
                    double curd2 = this.distance(fv, this.means[orig]);
                    u = this.isSquared ? Math.sqrt(curd2) : curd2;
                    this.upper.putDouble((DBIDRef)it, u);
                    if (!(u <= z) && !(u <= sa)) {
                        int sec = this.second.intValue((DBIDRef)it);
                        double secd2 = this.distance(fv, this.means[sec]);
                        double secd = this.isSquared ? Math.sqrt(secd2) : secd2;
                        double r = u > secd ? u : secd;
                        double norm = EuclideanDistance.STATIC.norm(fv);
                        double min1 = curd2;
                        double min2 = secd2;
                        int cur = orig;
                        int secIndex = sec;
                        if (curd2 > secd2) {
                            min1 = secd2;
                            min2 = curd2;
                            cur = sec;
                            secIndex = orig;
                        }
                        for (int i = 0; i < this.k; ++i) {
                            double d;
                            int c = this.cnum[i];
                            if (c == orig || c == sec || -(d = this.cdist[i] - norm) > r) continue;
                            if (d > r) break;
                            double dist = this.distance(fv, this.means[c]);
                            if (dist < min1) {
                                secIndex = cur;
                                cur = c;
                                min2 = min1;
                                min1 = dist;
                                continue;
                            }
                            if (!(dist < min2)) continue;
                            secIndex = c;
                            min2 = dist;
                        }
                        if (cur != orig) {
                            ((ModifiableDBIDs)this.clusters.get(cur)).add((DBIDRef)it);
                            ((ModifiableDBIDs)this.clusters.get(orig)).remove((DBIDRef)it);
                            this.assignment.putInt((DBIDRef)it, cur);
                            this.second.putInt((DBIDRef)it, secIndex);
                            AbstractKMeans.plusMinusEquals(this.sums[cur], this.sums[orig], fv);
                            ++changed;
                            this.upper.putDouble((DBIDRef)it, min1 == curd2 ? u : (this.isSquared ? Math.sqrt(min1) : min1));
                        }
                        this.lower.putDouble((DBIDRef)it, min2 == curd2 ? u : (this.isSquared ? Math.sqrt(min2) : min2));
                    }
                }
                it.advance();
            }
            return changed;
        }

        @Override
        protected Logging getLogger() {
            return LOG;
        }
    }
}

