/*
 * Decompiled with CFR 0.152.
 */
package elki.clustering.kmeans;

import elki.clustering.kmeans.KMeans;
import elki.clustering.kmeans.initialization.KMeansInitialization;
import elki.clustering.kmeans.quality.KMeansQualityMeasure;
import elki.data.Clustering;
import elki.data.NumberVector;
import elki.data.model.MeanModel;
import elki.data.type.TypeInformation;
import elki.database.relation.Relation;
import elki.distance.NumberVectorDistance;
import elki.logging.Logging;
import elki.logging.progress.AbstractProgress;
import elki.logging.progress.FiniteProgress;
import elki.utilities.optionhandling.OptionID;
import elki.utilities.optionhandling.Parameterizer;
import elki.utilities.optionhandling.constraints.CommonConstraints;
import elki.utilities.optionhandling.constraints.ParameterConstraint;
import elki.utilities.optionhandling.parameterization.Parameterization;
import elki.utilities.optionhandling.parameters.IntParameter;
import elki.utilities.optionhandling.parameters.ObjectParameter;

public class BestOfMultipleKMeans<V extends NumberVector, M extends MeanModel>
implements KMeans<V, M> {
    private static final Logging LOG = Logging.getLogger(BestOfMultipleKMeans.class);
    private int trials;
    private KMeans<V, M> innerkMeans;
    private KMeansQualityMeasure<? super V> qualityMeasure;

    public BestOfMultipleKMeans(int trials, KMeans<V, M> innerkMeans, KMeansQualityMeasure<? super V> qualityMeasure) {
        this.trials = trials;
        this.innerkMeans = innerkMeans;
        this.qualityMeasure = qualityMeasure;
    }

    public TypeInformation[] getInputTypeRestriction() {
        return this.innerkMeans.getInputTypeRestriction();
    }

    @Override
    public Clustering<M> run(Relation<V> relation) {
        NumberVectorDistance<V> df = this.innerkMeans.getDistance();
        Clustering<M> bestResult = null;
        double bestCost = Double.NaN;
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("K-means iterations", this.trials, LOG) : null;
        for (int i = 0; i < this.trials; ++i) {
            Clustering<M> currentCandidate = this.innerkMeans.run(relation);
            double currentCost = this.qualityMeasure.quality(currentCandidate, df, relation);
            if (LOG.isVerbose()) {
                LOG.verbose((CharSequence)("Cost of candidate " + i + ": " + currentCost));
            }
            if (this.qualityMeasure.isBetter(currentCost, bestCost)) {
                bestResult = currentCandidate;
                bestCost = currentCost;
            }
            LOG.incrementProcessed((AbstractProgress)prog);
        }
        LOG.ensureCompleted(prog);
        return bestResult;
    }

    @Override
    public NumberVectorDistance<? super V> getDistance() {
        return this.innerkMeans.getDistance();
    }

    @Override
    public void setK(int k) {
        this.innerkMeans.setK(k);
    }

    @Override
    public void setDistance(NumberVectorDistance<? super V> distance) {
        this.innerkMeans.setDistance(distance);
    }

    @Override
    public void setInitializer(KMeansInitialization init) {
        this.innerkMeans.setInitializer(init);
    }

    public static class Par<V extends NumberVector, M extends MeanModel>
    implements Parameterizer {
        public static final OptionID TRIALS_ID = new OptionID("kmeans.trials", "The number of trials to run.");
        public static final OptionID KMEANS_ID = new OptionID("kmeans.algorithm", "KMeans variant to run multiple times.");
        public static final OptionID QUALITYMEASURE_ID = new OptionID("kmeans.qualitymeasure", "Quality measure variant for deciding which run to keep.");
        protected int trials;
        protected KMeans<V, M> kMeansVariant;
        protected KMeansQualityMeasure<? super V> qualityMeasure;

        public void configure(Parameterization config) {
            ((IntParameter)new IntParameter(TRIALS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).grab(config, x -> {
                this.trials = x;
            });
            new ObjectParameter(KMEANS_ID, KMeans.class).grab(config, x -> {
                this.kMeansVariant = x;
            });
            new ObjectParameter(QUALITYMEASURE_ID, KMeansQualityMeasure.class).grab(config, x -> {
                this.qualityMeasure = x;
            });
        }

        public BestOfMultipleKMeans<V, M> make() {
            return new BestOfMultipleKMeans<V, M>(this.trials, this.kMeansVariant, this.qualityMeasure);
        }
    }
}

